// --> See Define.Txt for a line-by-line explanation of this file.
// It may help to browse through BASIC.Txt first.

uCalc Prefix "uCalc Define Pattern: "   
   :::        ~~ Properties: ucStatementSep
   ~t         ~~ Properties: ucCurrentThread
   ~Eval      ~~ Properties: ucEvalInsert
   ~Expand    ~~ Properties: ucExpandInsert
   \\q ~~ \\q ~~ Properties: ucQuotedText + ucLiteral ~~ DataType: String
   \\z ~~ \\z ~~ Properties: ucQuotedText + ucLiteral ~~ DataType: String
   ~mStart    ~~ Properties: ucPartialBlockStart
   ~mEnd      ~~ Properties: ucPartialBlockEnd
   \{ ~~ \}   ~~ Properties: ucCodeBlock ~~ DataType: Stack _
      ~~ Address: ucAddr(uc_Func_Populate_Stack) ~~ Rank: 10
uCalc Prefix ""

uCalc Define Rank: uc_Last ~~ Variable ~~ Name: _AlphaNum  ~~ DataType: String ~~ Value: "[a-z_][0-9a-z_]*"
uCalc Define Rank: uc_Last ~~ Variable ~~ Name: _AlphaNumV ~~ DataType: String ~~ Value: _AlphaNum

// All of the following syntax defs use a default precedence level of 1

uCalc Prefix "uCalc Syntax "
   Name_: ::= Name:

   Var: ::=

   Var: {"[ ]*"}{VarName:_AlphaNum} [As {Type}] _
      [{ = {Value} | At {Addr:" .+"} }] ::=          _
      Variable ~~ Name_: {VarName}                   _
      {Type: ~~ DataType: {Type}}                    _
      {Value: ~~ Value: {Value}}                     _
      {Addr: ~~ Address: {Addr}}

   Var: {"[ ]*"}{VarName:_AlphaNumV} As AnyType ::= AnyType~~Var: {VarName}
   Var: {PassBy:"( +ByRef)|( +ByVal)|( +ByHandle)|( +ByExpr)"}::={PassBy}~~Var:
   Var: {Def} ... ::= Var: {Def} ~~ VariableArgList
   Var: ... ::= Var: _ ~~ VariableArgList

   Var: {"[ ]*"}{ArrayName:_AlphaNum} ({MaxIndex}) [{etc}] _
      ::= SetInput(\zuCalc Syntax {ArrayName} ({Index})                      _
          ::= ValueAtAddr(~Eval(DataType(\q{ArrayName}\q)),                    _
                          ~Eval(Address(\q{ArrayName}\q)), {Index})\z)         _
      Count: {MaxIndex} ~~ Var: {ArrayName} {etc}

   Const: {Def:".*"} ::= Var: {Def} ~~ Properties: ucLock


   Params: ([{SingleParam}])::=IsParam ~~ { {SingleParam: Var: {SingleParam}} }
   Params: ({Variable:"[^=]+"} = {Default}) _
           ::= Params: ({Variable} ~~ TextData: {Default})
   Params: ({Param1}, {OtherParams}) ::= Params: ({Param1}) _
           ~~ Params: ({OtherParams})
   Param:  {ParamDef} ~~ ::= IsParam ~~ { Var: {ParamDef} } ~~


   Func: ::=
   Func: {FuncName} ([{ParamList}])                                           _
      [As {"[ ]+"}{type:_AlphaNumV}] [{ At {addr:".+"} | = {Def:".+"} }] ::= _
      Properties: ucFunction + ucPrefix ~~                                    _
      Params: ({ParamList}) ~~ DataType: {type} ~~ Name_: {FuncName}          _
      {addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}

   Func:: ::=
   Func:: {Def:".+"} ::= NativeCall ~~ Func: {Def}

   Op: ::=
   Op: {Name} "{" {Operand} "}" [As {"[ ]+"}{type:_AlphaNumV}] _
      [{ At {addr} | = {Def:".+"} }] ::= _
      Properties: ucPrefix+ucOperator ~~ Param: {Operand} ~~ Name_: {Name} ~~ _
      DataType: {type} {addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}

   Op: "{" {Operand} "}" {Name} [As {"[ ]+"}{type:_AlphaNumV}] _
      [{ At {addr} | = {Def:".+"} }]  ::= _
      Properties: ucPostfix+ucOperator ~~ Param: {Operand} ~~ Name_: {Name} ~~ _
      DataType: {type} {addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}

   Op: "{"{LeftOp}"}" {Name} "{" {RightOp} "}" [As {"[ ]+"}{type:_AlphaNumV}] _
      [{ At {addr} | = {Def:".+"} }] ::= Name_: {Name} ~~                      _
      Properties: ucInfix+ucOperator ~~ Param: {LeftOp} ~~ Param: {RightOp} ~~ _
      DataType: {type} {addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}

   Op: {pValue:' *[0-9]+ '} {Def} ::= Precedence: {pValue} ~~ Op: {Def}
   Op: Precedence({op}) ::= Op: ~Eval(Precedence({op}))

   Op:: ::=
   Op:: {Def:".+"} ::= NativeCall ~~ Op: {Def}

   Macro: {name} [{args:\q\([^\)]*\)\q}] = {replacement} ::= _
      Syntax: ~Eval(SetSyntaxParams(\q{args}\q, \q{name}{args} ::= {replacement}\q))

   syntax {Def:" .+"} ::= SetInput("ucalc syntax {Def}")
   func   {Def:" .+"} ::= SetInput("ucalc define func: {Def}")
   var    {Def:" .+"} ::= SetInput("ucalc define var: {Def}")
   const  {Def:" .+"} ::= SetInput("ucalc define const: {Def}")
   expand {Def:" .+"} ::= SetInput("ucalc expand {Def}")
uCalc Prefix ""