ucalc:LISP> ; These test examples mostly come from the great Lisp Primer tutorial
ucalc:LISP> ; found at mypage.iu.edu/~colallen/lp/ and are taken with permission.
ucalc:LISP> (+ 1 2 3 4)
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> (setq my-age 9)
ucalc:LISP> 9
ucalc:LISP> 
ucalc:LISP> my-age
ucalc:LISP> 9
ucalc:LISP> 
ucalc:LISP> (setq my-age 10)
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> my-age
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> 9
ucalc:LISP> 9
ucalc:LISP> 
ucalc:LISP> 10
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> my-age
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> t
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> nil
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> ()
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (+ 2 13 45)
ucalc:LISP> 60
ucalc:LISP> 
ucalc:LISP> (+ my-age 1)
ucalc:LISP> 11
ucalc:LISP> 
ucalc:LISP> (cons 1 nil)
ucalc:LISP> (1)
ucalc:LISP> 
ucalc:LISP> (cons 1 (cons 2 nil))
ucalc:LISP> (1 2)
ucalc:LISP> 
ucalc:LISP> 'a
ucalc:LISP> A
ucalc:LISP> 
ucalc:LISP> (cons 'a '(b c d))
ucalc:LISP> (A B C D)
ucalc:LISP> 
ucalc:LISP> (list 2 3 4)
ucalc:LISP> (2 3 4)
ucalc:LISP> 
ucalc:LISP> (list 'a '(a s d f))
ucalc:LISP> (A (A S D F))
ucalc:LISP> 
ucalc:LISP> (append '(a b) '(c d))
ucalc:LISP> (A B C D)
ucalc:LISP> 
ucalc:LISP> (first '(a s d f))
ucalc:LISP> A
ucalc:LISP> 
ucalc:LISP> (first '((a s) d f))
ucalc:LISP> (A S)
ucalc:LISP> 
ucalc:LISP> (rest '(a s d f))
ucalc:LISP> (S D F)
ucalc:LISP> 
ucalc:LISP> (rest '((a s) d f))
ucalc:LISP> (D F)
ucalc:LISP> 
ucalc:LISP> (rest '((a s) (d f)))
ucalc:LISP> ((D F))
ucalc:LISP> 
ucalc:LISP> (setq a '(a s d f))
ucalc:LISP> (A S D F)
ucalc:LISP> 
ucalc:LISP> (first a)
ucalc:LISP> A
ucalc:LISP> 
ucalc:LISP> (rest a)
ucalc:LISP> (S D F)
ucalc:LISP> 
ucalc:LISP> (first (rest a))
ucalc:LISP> S
ucalc:LISP> 
ucalc:LISP> (cons 'a a)
ucalc:LISP> (A A S D F)
ucalc:LISP> 
ucalc:LISP> a
ucalc:LISP> (A S D F)
ucalc:LISP> 
ucalc:LISP> (setq a (cons 'a a))
ucalc:LISP> (A A S D F)
ucalc:LISP> 
ucalc:LISP> a
ucalc:LISP> (A A S D F)
ucalc:LISP> 
ucalc:LISP> (length '(1 2 3))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (length a)
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (length (append a a))
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> (length '(append a a))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (length (list a a))
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (atom 'a)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (atom a)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (listp 'a)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (listp a)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (atom nil)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (listp nil)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (setq my-age (+ my-age 1))
ucalc:LISP> 11
ucalc:LISP> 
ucalc:LISP> (setq a (cdr a))
ucalc:LISP> (A S D F)
ucalc:LISP> 
ucalc:LISP> (setq words '(a list of words))
ucalc:LISP> (A LIST OF WORDS)
ucalc:LISP> 
ucalc:LISP> (setq words (cons 'this (rest words)))
ucalc:LISP> (THIS LIST OF WORDS)
ucalc:LISP> 
ucalc:LISP> (first '(((a)) (b c d e)))
ucalc:LISP> ((A))
ucalc:LISP> 
ucalc:LISP> (rest '(((((f))))))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (first '(rest (a b c)))
ucalc:LISP> REST
ucalc:LISP> 
ucalc:LISP> (first '(rest (rest (a b c))))
ucalc:LISP> REST
ucalc:LISP> 
ucalc:LISP> (cons '(my life as) '(a dog))
ucalc:LISP> ((MY LIFE AS) A DOG)
ucalc:LISP> 
ucalc:LISP> (append '(my life as) '(a dog))
ucalc:LISP> (MY LIFE AS A DOG)
ucalc:LISP> 
ucalc:LISP> (list '(my life as) '(a dog))
ucalc:LISP> ((MY LIFE AS) (A DOG))
ucalc:LISP> 
ucalc:LISP> (cons (rest nil) (first nil))
ucalc:LISP> (NIL)
ucalc:LISP> 
ucalc:LISP> (abs (- (length (rest '(((a b) (c d))))) 5))
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (setf trek '(picard riker laforge worf))
ucalc:LISP> (PICARD RIKER LAFORGE WORF)
ucalc:LISP> 
ucalc:LISP> (cons 'data trek)
ucalc:LISP> (DATA PICARD RIKER LAFORGE WORF)
ucalc:LISP> 
ucalc:LISP> trek
ucalc:LISP> (PICARD RIKER LAFORGE WORF)
ucalc:LISP> 
ucalc:LISP> (length (cons 'troi trek))
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (setf trek (cons 'data trek))
ucalc:LISP> (DATA PICARD RIKER LAFORGE WORF)
ucalc:LISP> 
ucalc:LISP> (length (cons 'troi trek)
ucalc:LISP>>)
ucalc:LISP> 6
ucalc:LISP> 
ucalc:LISP> (defun square (x)
ucalc:LISP>>   (* x x))
ucalc:LISP> SQUARE
ucalc:LISP> 
ucalc:LISP> (square 2)
ucalc:LISP> 4
ucalc:LISP> 
ucalc:LISP> (setf x 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (square 345)
ucalc:LISP> 119025
ucalc:LISP> 
ucalc:LISP> x
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (defun y-plus (x)
ucalc:LISP>>   (+ x y))
ucalc:LISP> Y-PLUS
ucalc:LISP> 
ucalc:LISP> (setq y 2)
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (y-plus 4)
ucalc:LISP> 6
ucalc:LISP> 
ucalc:LISP> (setq x 5)
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (y-plus 23)
ucalc:LISP> 25
ucalc:LISP> 
ucalc:LISP> x
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (setq y 27)
ucalc:LISP> 27
ucalc:LISP> 
ucalc:LISP> (y-plus 43)
ucalc:LISP> 70
ucalc:LISP> 
ucalc:LISP> (defun fourth-power (x)
ucalc:LISP>>   (square (square x)))
ucalc:LISP> FOURTH-POWER
ucalc:LISP> 
ucalc:LISP> (fourth-power 2)
ucalc:LISP> 16
ucalc:LISP> 
ucalc:LISP> (defun powers-of (x)
ucalc:LISP>>   (square x)
ucalc:LISP>>   (fourth-power x))
ucalc:LISP> POWERS-OF
ucalc:LISP> 
ucalc:LISP> (powers-of 2)
ucalc:LISP> 16
ucalc:LISP> 
ucalc:LISP> (defun powers-of (x)
ucalc:LISP>>   (setq y (square x))
ucalc:LISP>>   (fourth-power x))
ucalc:LISP> POWERS-OF
ucalc:LISP> 
ucalc:LISP> y
ucalc:LISP> 27
ucalc:LISP> 
ucalc:LISP> (powers-of 7)
ucalc:LISP> 2401
ucalc:LISP> 
ucalc:LISP> y
ucalc:LISP> 49
ucalc:LISP> 
ucalc:LISP> (if (symbolp foo) (* 5 5) (+ 5 5))
ucalc:LISP> 25
ucalc:LISP> 
ucalc:LISP> (if (symbolp 1) (* 5 5) (+ 5 5))
ucalc:LISP> 10
ucalc:LISP> 
ucalc:LISP> (if t 'test-was-true 'test-was-false)
ucalc:LISP> TEST-WAS-TRUE
ucalc:LISP> 
ucalc:LISP> (if nil 'test-was-true 'test-was-false)
ucalc:LISP> TEST-WAS-FALSE
ucalc:LISP> 
ucalc:LISP> (defun absdiff (x y)
ucalc:LISP>>   (if (> x y)
ucalc:LISP>>       (- x y)
ucalc:LISP>>       (- y x)))
ucalc:LISP> ABSDIFF
ucalc:LISP> 
ucalc:LISP> (absdiff 10 3)
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (absdiff 3 10)
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (defun absdiff (x y) 1000)
ucalc:LISP> ABSDIFF
ucalc:LISP> 
ucalc:LISP> (absdiff 3 4)
ucalc:LISP> 1000
ucalc:LISP> 
ucalc:LISP> (defun absdiff (x y)
ucalc:LISP>>   (cond ((> x y) (- x y))
ucalc:LISP>>         (t (- y x))))
ucalc:LISP> ABSDIFF
ucalc:LISP> 
ucalc:LISP> (absdiff 3 10)
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (absdiff 10 3)
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (= 3 3.0)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (= 3/1 6/2)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (equal 3 3)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (equal 3 3.0)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (setf a '(1 2 3 4))
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (setf b '(1 2 3 4))
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (setf c b)
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (equal a b)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (equal b c)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (= (first a) (first b))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (null nil)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (not nil)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (null ())
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (not ())
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (null '( a s))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (not '(a s))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (not (= 1 (* 1 1)))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (null (= 1 (* 1 1)))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (and 1 2 3 4)
ucalc:LISP> 4
ucalc:LISP> 
ucalc:LISP> (and 1 (cons 'a '(b)) (rest '(a)) (setf y 'hello))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> y
ucalc:LISP> 49
ucalc:LISP> 
ucalc:LISP> (or nil nil 2 (setf y 'goodbye))
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (or (rest '(a)) (equal 3 4))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (defun life (a b)
ucalc:LISP>>   (cond ((null a) b)
ucalc:LISP>>         ((null b) a)
ucalc:LISP>>         (t 'its-tough)))
ucalc:LISP> LIFE
ucalc:LISP> 
ucalc:LISP> (setf a 'oh-boy)
ucalc:LISP> OH-BOY
ucalc:LISP> 
ucalc:LISP> (life 'gummi a)
ucalc:LISP> ITS-TOUGH
ucalc:LISP> 
ucalc:LISP> (defun circulate (lst)
ucalc:LISP>>   (append (rest lst)
ucalc:LISP>>           (list (first lst))))
ucalc:LISP> CIRCULATE
ucalc:LISP> 
ucalc:LISP> (circulate '((whats) happening here))
ucalc:LISP> (HAPPENING HERE (WHATS))
ucalc:LISP> 
ucalc:LISP> (circulate nil)
ucalc:LISP> (NIL)
ucalc:LISP> 
ucalc:LISP> (defun power (x y)
ucalc:LISP>>   (if (= y 0) 1
ucalc:LISP>>      (* x (power x (1- y)))))
ucalc:LISP> POWER
ucalc:LISP> 
ucalc:LISP> (power 3 4)
ucalc:LISP> 81
ucalc:LISP> 
ucalc:LISP> (defun num-sublists (lis)
ucalc:LISP>>   (cond
ucalc:LISP>>      ((null lis) 0)
ucalc:LISP>>      ((listp (first lis))
ucalc:LISP>>       (1+ (num-sublists (rest lis))))
ucalc:LISP>>      (t (num-sublists (rest lis)))))
ucalc:LISP> NUM-SUBLISTS
ucalc:LISP> 
ucalc:LISP> (num-sublists '(a b c))
ucalc:LISP> 0
ucalc:LISP> 
ucalc:LISP> (num-sublists '(a (b c)))
ucalc:LISP> 1
ucalc:LISP> 
ucalc:LISP> (num-sublists '(a (b c) q (4 5)))
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (let ((x 3)
ucalc:LISP>>      (y (- 67 34)))
ucalc:LISP>>   (* x y))
ucalc:LISP> 99
ucalc:LISP> 
ucalc:LISP> a
ucalc:LISP> OH-BOY
ucalc:LISP> 
ucalc:LISP> b
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (let ((a 3)
ucalc:LISP>>      (b a)))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> b
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (let ((a 3)
ucalc:LISP>>      (b a)) b)
ucalc:LISP> OH-BOY
ucalc:LISP> 
ucalc:LISP> b
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> a
ucalc:LISP> OH-BOY
ucalc:LISP> 
ucalc:LISP> (let* ((a 3)
ucalc:LISP>>       (b a)) b)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> b
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (defun mymax (nums)
ucalc:LISP>>   (cond ((= (length nums) 1) (car nums))
ucalc:LISP>>         ((> (car nums) (cadr nums))
ucalc:LISP>>          (mymax (cons (car nums)
ucalc:LISP>>                       (cddr nums))))
ucalc:LISP>>          (t (mymax (cdr nums)))))
ucalc:LISP> MYMAX
ucalc:LISP> 
ucalc:LISP> (mymax '(1 3 412 43 1 1 3412 53 43 43 54))
ucalc:LISP> 3412
ucalc:LISP> 
ucalc:LISP> (defun palindromep (lst)
ucalc:LISP>>   (equal lst (reverse lst)) )
ucalc:LISP> PALINDROMEP
ucalc:LISP> 
ucalc:LISP> (palindromep '(1 2 3 4 5 4 3 2 1))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (palindromep '(a b b a))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (palindromep '(1 2 3))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (defun remove (lst elt)
ucalc:LISP>>   (cond ((null lst) nil)
ucalc:LISP>>         ((equal (first lst) elt) (rest lst))
ucalc:LISP>>         (t (cons (first lst)
ucalc:LISP>>                  (remove (rest lst) elt)))))
ucalc:LISP> REMOVE
ucalc:LISP> 
ucalc:LISP> (remove '(a 1 c 2 c 7) 'c)
ucalc:LISP> (A 1 2 C 7)
ucalc:LISP> 
ucalc:LISP> (remove '(a (1 q) 2) 'q)
ucalc:LISP> (A (1 Q) 2)
ucalc:LISP> 
ucalc:LISP> (defun mylength (lst)
ucalc:LISP>>   (cond ((null lst) 0)
ucalc:LISP>>         (t (+ 1 (mylength (rest lst))))))
ucalc:LISP> MYLENGTH
ucalc:LISP> 
ucalc:LISP> (mylength nil)
ucalc:LISP> 0
ucalc:LISP> 
ucalc:LISP> (mylength '(a b))
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (mylength '(a b c d e f g))
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (mylength '(a (2 q) 64))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (defun search (lst elt)
ucalc:LISP>>   (cond ((null lst) nil)
ucalc:LISP>>         ((atom (first lst))
ucalc:LISP>>         (if (equal (first lst) elt)
ucalc:LISP>>            't
ucalc:LISP>>            (search (rest lst) elt)))
ucalc:LISP>>         (t (or (search (first lst) elt)
ucalc:LISP>>                (search (rest lst) elt)))))
ucalc:LISP> SEARCH
ucalc:LISP> 
ucalc:LISP> (search '(a (1 c) 2 7) 'c)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (search '(a (1 c) 2 7) 'q)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (defun sum-of-list (lst)
ucalc:LISP>>   (cond ((null lst) 0)
ucalc:LISP>>      (t (+ (first lst)
ucalc:LISP>>            (sum-of-list (rest lst))))))
ucalc:LISP> SUM-OF-LIST
ucalc:LISP> 
ucalc:LISP> (defun product-of-list (lst)
ucalc:LISP>>   (cond ((null lst) 1)
ucalc:LISP>>      (t (* (first lst)
ucalc:LISP>>            (product-of-list (rest lst))))))
ucalc:LISP> PRODUCT-OF-LIST
ucalc:LISP> 
ucalc:LISP> (sum-of-list '(2 3 4 5))
ucalc:LISP> 14
ucalc:LISP> 
ucalc:LISP> (product-of-list '(2 3 4 5))
ucalc:LISP> 120
ucalc:LISP> 
ucalc:LISP> (defun factorial (n)
ucalc:LISP>>   (cond ((= n 0) 1)
ucalc:LISP>>      (t (* n (factorial (- n 1))))))
ucalc:LISP> FACTORIAL
ucalc:LISP> 
ucalc:LISP> (factorial 5)
ucalc:LISP> 120
ucalc:LISP> 
ucalc:LISP> (defun remainder (n m)
ucalc:LISP>>   (cond ((< n m) n)
ucalc:LISP>>         (t (remainder (- n m) m))))
ucalc:LISP> REMAINDER
ucalc:LISP> 
ucalc:LISP> (remainder 30 7)
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (defun my-exp (x y)
ucalc:LISP>>   (cond ((= y 0) 1)
ucalc:LISP>>      (t (* x (my-exp x (- y 1))))))
ucalc:LISP> MY-EXP
ucalc:LISP> 
ucalc:LISP> (my-exp 3 4)
ucalc:LISP> 81
ucalc:LISP> 
ucalc:LISP> (defun cube-list (lst)
ucalc:LISP>>   (cond ((null lst) nil)
ucalc:LISP>>      (t (cons (* (first lst)
ucalc:LISP>>                  (first lst)
ucalc:LISP>>                  (first lst))
ucalc:LISP>>               (cube-list (rest lst))))))
ucalc:LISP> CUBE-LIST
ucalc:LISP> 
ucalc:LISP> (cube-list '(5 3 -15))
ucalc:LISP> (125 27 -3375)
ucalc:LISP> 
ucalc:LISP> (defun cubeB (lst)
ucalc:LISP>>   (cond ((null lst) nil)
ucalc:LISP>>      (t (let ((elt (first lst)))
ucalc:LISP>>         (cons (* elt elt elt)
ucalc:LISP>>               (cubeB (rest lst)))))))
ucalc:LISP> CUBEB
ucalc:LISP> 
ucalc:LISP> (cubeB '(-15 5 3))
ucalc:LISP> (-3375 125 27)
ucalc:LISP> 
ucalc:LISP> (defun cube (elt)
ucalc:LISP>>   (* elt elt elt))
ucalc:LISP> CUBE
ucalc:LISP> 
ucalc:LISP> (defun cubeC (lst)
ucalc:LISP>>   (cond ((null lst) nil)
ucalc:LISP>>      (t (cons (cube (first lst))
ucalc:LISP>>         (cubeC (rest lst))))))
ucalc:LISP> CUBEC
ucalc:LISP> 
ucalc:LISP> (cubec '(3 5 -15))
ucalc:LISP> (27 125 -3375)
ucalc:LISP> 
ucalc:LISP> "This is a string"
ucalc:LISP> "This is a string"
ucalc:LISP> 
ucalc:LISP> (cons "this" '(here))
ucalc:LISP> ("this" HERE)
ucalc:LISP> 
ucalc:LISP> (print 'this)
ucalc:LISP> THIS
ucalc:LISP> 
ucalc:LISP> (print (+ 1 2))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (+ (print 1) (print 2))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> `(2 ,(+ 3 4))
ucalc:LISP> (2 7)
ucalc:LISP> 
ucalc:LISP> `(4 ,(+ 1 2) '(3 ,(+ 1 2)) 5)
ucalc:LISP> (4 3 '(3 3) 5)
ucalc:LISP> 
ucalc:LISP> (defmacro 2plus (x) (+ x 2))
ucalc:LISP> 2PLUS
ucalc:LISP> 
ucalc:LISP> (2plus 3)
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (setf a (2plus 3))
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> a
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (defmacro just-first-macro (x y) x)
ucalc:LISP> JUST-FIRST-MACRO
ucalc:LISP> 
ucalc:LISP> (just-first-macro 3 4)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (just-first-macro 3 (print 4))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (defun just-first-function (x y) x)
ucalc:LISP> JUST-FIRST-FUNCTION
ucalc:LISP> 
ucalc:LISP> (just-first-function 3 (print 4))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (* 4 5 6)
ucalc:LISP> 120
ucalc:LISP> 
ucalc:LISP> (* 123.5 12/3)
ucalc:LISP> 494
ucalc:LISP> 
ucalc:LISP> (* (* 2 3) 8)
ucalc:LISP> 48
ucalc:LISP> 
ucalc:LISP> (* 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (*)
ucalc:LISP> 1
ucalc:LISP> 
ucalc:LISP> (+ 4 5 6)
ucalc:LISP> 15
ucalc:LISP> 
ucalc:LISP> (+ 123.5 12/3)
ucalc:LISP> 127.5
ucalc:LISP> 
ucalc:LISP> (+ (* 2 3) 8)
ucalc:LISP> 14
ucalc:LISP> 
ucalc:LISP> (+ 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (+)
ucalc:LISP> 0
ucalc:LISP> 
ucalc:LISP> (- 1)
ucalc:LISP> -1
ucalc:LISP> 
ucalc:LISP> (- 1 2)
ucalc:LISP> -1
ucalc:LISP> 
ucalc:LISP> (- 1 2 3)
ucalc:LISP> -4
ucalc:LISP> 
ucalc:LISP> (- 1 2 3 4)
ucalc:LISP> -8
ucalc:LISP> 
ucalc:LISP> (1+ 3)
ucalc:LISP> 4
ucalc:LISP> 
ucalc:LISP> (1+ (1- 3))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (= 2)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (= 2 3)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (= 2 3 4)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (= 2 2 2 2 )
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (= 2 2 3 2)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (< 2 67)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (< 67 2)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (> 67 2)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (< 3 6 9)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (< 4)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (< 2 2 6)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (<= 2 2 6)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (>= 2 2 6)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (< 6/2 3.0)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (and 3 (+ 4 5))
ucalc:LISP> 9
ucalc:LISP> 
ucalc:LISP> (and nil (print 'hello))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (and t (print 'hello) 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (and)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (append '(a b) '(c d))
ucalc:LISP> (A B C D)
ucalc:LISP> 
ucalc:LISP> (append '(1 (2 (3))) '(i (j) k))
ucalc:LISP> (1 (2 (3)) I (J) K)
ucalc:LISP> 
ucalc:LISP> (setq tmp '(fee fi fo))
ucalc:LISP> (FEE FI FO)
ucalc:LISP> 
ucalc:LISP> (append tmp (list 'fum))
ucalc:LISP> (FEE FI FO FUM)
ucalc:LISP> 
ucalc:LISP> (atom 'hello)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (atom "hello")
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (atom 4.6434)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (atom '(hello "hello" 4.6434))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (butlast '(a s d f))
ucalc:LISP> (A S D)
ucalc:LISP> 
ucalc:LISP> (butlast '(a s d f) 2)
ucalc:LISP> (A S)
ucalc:LISP> 
ucalc:LISP> (butlast '(a s d f) 0)
ucalc:LISP> (A S D F)
ucalc:LISP> 
ucalc:LISP> (reverse (nthcdr 2 (reverse '(a s d f))))
ucalc:LISP> (A S)
ucalc:LISP> 
ucalc:LISP> (setf ds9 '(Sisko Kira Dax Odo Bashir Obrien))
ucalc:LISP> (SISKO KIRA DAX ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (cadr ds9)
ucalc:LISP> KIRA
ucalc:LISP> 
ucalc:LISP> (cddr ds9)
ucalc:LISP> (DAX ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (setq a '3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (setq b '4)
ucalc:LISP> 4
ucalc:LISP> 
ucalc:LISP> (cond ((= a b) 'equal)
ucalc:LISP>>   ((< a b) 'b-is-bigger)
ucalc:LISP>>   (t 'a-is-bigger))
ucalc:LISP> B-IS-BIGGER
ucalc:LISP> 
ucalc:LISP> (setq action 'square-both)
ucalc:LISP> SQUARE-BOTH
ucalc:LISP> 
ucalc:LISP> (cond ((equal action 'clear-both)
ucalc:LISP>>      (setq a 0)
ucalc:LISP>>      (setq b 0))
ucalc:LISP>>     ((equal action 'square-both)
ucalc:LISP>>      (setq a (* a a))
ucalc:LISP>>      (setq b (* b b)))
ucalc:LISP>>     ((equal action 'square-a)
ucalc:LISP>>      (setq a (* a a)))
ucalc:LISP>>     ((equal action 'square-b)
ucalc:LISP>>      (setq b (* b b))))
ucalc:LISP> 16
ucalc:LISP> 
ucalc:LISP> (cond ((= a 5) 'found)
ucalc:LISP>>      ((= b 5) 'found))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (cons 'a '(1 2 3))
ucalc:LISP> (A 1 2 3)
ucalc:LISP> 
ucalc:LISP> (cons '(a) '(1 2 3))
ucalc:LISP> ((A) 1 2 3)
ucalc:LISP> 
ucalc:LISP> (setq a 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (cons a (list 'i 'j 'k))
ucalc:LISP> (3 I J K)
ucalc:LISP> 
ucalc:LISP> (defun square (x) (* x x))
ucalc:LISP> SQUARE
ucalc:LISP> 
ucalc:LISP> (square 4)
ucalc:LISP> 16
ucalc:LISP> 
ucalc:LISP> (square (+ 7 -2))
ucalc:LISP> 25
ucalc:LISP> 
ucalc:LISP> (defun equal-length (lst1 lst2)
ucalc:LISP>>   (cond ((= (length lst1) (length lst2)) t)
ucalc:LISP>>      (t nil)))
ucalc:LISP> EQUAL-LENGTH
ucalc:LISP> 
ucalc:LISP> (equal-length '(a b c) '((d e) f g))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (equal-length '() (rest '(a b)))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (defun side-effect (x y)
ucalc:LISP>>   (setq x (* x x x))
ucalc:LISP>>   (+ x y))
ucalc:LISP> SIDE-EFFECT
ucalc:LISP> 
ucalc:LISP> (side-effect 2 3)
ucalc:LISP> 11
ucalc:LISP> 
ucalc:LISP> (side-effect -4 14)
ucalc:LISP> -50
ucalc:LISP> 
ucalc:LISP> (equal 'hey 'hello)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (equal -81 -81)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (equal '(1 (2 3)) '(1 (2 3)))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (setq a '(1 2 3))
ucalc:LISP> (1 2 3)
ucalc:LISP> 
ucalc:LISP> (setq b '(1 2 3))
ucalc:LISP> (1 2 3)
ucalc:LISP> 
ucalc:LISP> (equal a b)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (setq c a)
ucalc:LISP> (1 2 3)
ucalc:LISP> 
ucalc:LISP> (equal a c)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (eval '(+ 1 2))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (eval (cons '+ '(1 2)))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (eval 3)
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (eval (+ 3 4))
ucalc:LISP> 7
ucalc:LISP> 
ucalc:LISP> (first '(1 2 3))
ucalc:LISP> 1
ucalc:LISP> 
ucalc:LISP> (first '((a (b (c)) d) e (f)))
ucalc:LISP> (A (B (C)) D)
ucalc:LISP> 
ucalc:LISP> (first ())
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (if (>  4 3) 4 3)
ucalc:LISP> 4
ucalc:LISP> 
ucalc:LISP> (if (< 4 3)
ucalc:LISP>>   (- 4 3)
ucalc:LISP>>   (- 3 4))
ucalc:LISP> -1
ucalc:LISP> 
ucalc:LISP> (if (= 4 3) t)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (if (= 4 (+ 3 1)) t)
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (length '(1 2 3 4 5))
ucalc:LISP> 5
ucalc:LISP> 
ucalc:LISP> (length "1 2 3 4 5")
ucalc:LISP> 9
ucalc:LISP> 
ucalc:LISP> (length nil)
ucalc:LISP> 0
ucalc:LISP> 
ucalc:LISP> (let ((a)
ucalc:LISP>>      (b))
ucalc:LISP>>   (and (not a) (not b)))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (let ((a 3)
ucalc:LISP>>      (b 4))
ucalc:LISP>>   (setf a (+ a b))
ucalc:LISP>>   (setf b (+ a b))
ucalc:LISP>>   (+ a b))
ucalc:LISP> 18
ucalc:LISP> 
ucalc:LISP> (list 'picard 'riker 'worf 'crusher)
ucalc:LISP> (PICARD RIKER WORF CRUSHER)
ucalc:LISP> 
ucalc:LISP> (list 'picard '(riker worf crusher))
ucalc:LISP> (PICARD (RIKER WORF CRUSHER))
ucalc:LISP> 
ucalc:LISP> (list 1 (+ 1 1) (+ 1 1 1) (+ 1 1 1 1))
ucalc:LISP> (1 2 3 4)
ucalc:LISP> 
ucalc:LISP> (listp '(a s d f))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (listp 3)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (listp (cons '1 '(2 3 4)))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (nth 0 '(picard riker work crush))
ucalc:LISP> PICARD
ucalc:LISP> 
ucalc:LISP> (nth 2 '(( captain picard)
ucalc:LISP>>        (commander riker)
ucalc:LISP>>        (lieutenant worf)
ucalc:LISP>>        (ensign crusher)))
ucalc:LISP> (LIEUTENANT WORF)
ucalc:LISP> 
ucalc:LISP> (setf ds9 '(Sisko Kira Dax Odo Bashir Obrien)
ucalc:LISP>>)
ucalc:LISP> (SISKO KIRA DAX ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (nthcdr 0 ds9)
ucalc:LISP> (SISKO KIRA DAX ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (nthcdr 1 ds9)
ucalc:LISP> (KIRA DAX ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (nthcdr 3 ds9)
ucalc:LISP> (ODO BASHIR OBRIEN)
ucalc:LISP> 
ucalc:LISP> (nthcdr 2345 ds9)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (null '(picard riker))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (null (rest '(picard)))
ucalc:LISP> T
ucalc:LISP> 
ucalc:LISP> (or 3 (+ 4 5))
ucalc:LISP> 3
ucalc:LISP> 
ucalc:LISP> (or nil (print 'hello))
ucalc:LISP> HELLO
ucalc:LISP> 
ucalc:LISP> (or nil '(print hello) 3)
ucalc:LISP> (PRINT HELLO)
ucalc:LISP> 
ucalc:LISP> (or)
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (rest '(1 2 3))
ucalc:LISP> (2 3)
ucalc:LISP> 
ucalc:LISP> (rest '((a (b (c)) d) e (f)))
ucalc:LISP> (E (F))
ucalc:LISP> 
ucalc:LISP> (rest '(r))
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (rest ())
ucalc:LISP> NIL
ucalc:LISP> 
ucalc:LISP> (reverse '(picard riker worf crusher))
ucalc:LISP> (CRUSHER WORF RIKER PICARD)
ucalc:LISP> 
ucalc:LISP> (reverse (reverse '(picard riker worf crusher)))
ucalc:LISP> (PICARD RIKER WORF CRUSHER)
ucalc:LISP> 
ucalc:LISP> (reverse '((this list) (of words)))
ucalc:LISP> ((OF WORDS) (THIS LIST))
ucalc:LISP> 
ucalc:LISP> (second '(1 2 3 4))
ucalc:LISP> 2
ucalc:LISP> 
ucalc:LISP> (fourth '(1 2 3 4))
ucalc:LISP> 4
ucalc:LISP> 
