Dim cr As String = Chr(13) + Chr(10)
Dim TutorialHelp As String =                      cr+cr+ _
"     uCalc Language Builder Tutorial Help"      +cr+cr+ _
"     F1   Display this help screen"                +cr+ _
"     F2   Display the uCalc Language Builder help file" +cr+ _
"     F3   Display the uCalc Interpreter help file" +cr+ _
"     F4   Return to previous topic"                +cr+ _
"     F5   Continue to the next topic"              +cr+ _
"     F6   Open the current file with Notepad"      +cr+ _
"     F7   View the Tutorial's table of contents"   +cr+ _
"     F10  Exit completely from the tutorial and interpreter"+cr

Dim TableOfContents As String =                   cr+cr+ _
"PART 1. The interpreter as a calculator / expression evaluator"+cr+ _
"  a. General operators and functions you can use"  +cr+ _
"  b. Keyboard Shortcuts"                           +cr+ _
"  c. Defining things"                              +cr+ _
"  d.   Variables"                                  +cr+ _
"  e.   Function definitions"                       +cr+ _
"  f.     Prefix shortcut"                          +cr+ _
"  g.     Bootstrapping a definition"               +cr+ _
"  h.     Redefining a function"                    +cr+ _
"  i.   Macro definitions"                          +cr+ _
"  j.   Operator definitions"                       +cr+ _
"  k.   Windows API routines and other callbacks"   +cr+ _
"  l.   Callbacks from your host program"           +cr+ _
"  m.   NativeCall callbacks"                       +cr+ _
"  n.   Defining / declaring data types"            +cr+ _
"  o.   Defining character patterns"                +cr+ _
"  p. Log files"                                    +cr+ _
""                                                  +cr+ _
"PART 2. Underneath the hood of the Interpreter"    +cr+ _
"  a. Intro"                                        +cr+ _
"  b. Math notation"                                +cr+ _
"  c. Another thread"                               +cr+ _
"  d. Library.uc"                                   +cr+ _
"  e. Modifying things"                             +cr+ _
"  f. Defining a definition construct"              +cr+ _
"  g. Expanding an expression"                      +cr+ _
""                                                  +cr+ _
"PART 3 Adding language flavors / Constructing a language" +cr+ _
"  a. Intro"                                        +cr+ _
"  b. Python flavor"                                +cr+ _
"  c. BASIC flavor"                                 +cr+ _
"  d. The Forth language"                           +cr+ _
"  e. The Logo language"                            +cr+ _
"  f. The Lisp language"                            +cr+ _
""                                                  +cr+ _
"CONCLUSION"                                        +cr+ _
""                                                  +cr+ _
"To jump to a topic, enter the word Jump followed by"+cr+ _
"the section.  For instance 'Jump 1p', or 'Jump 2c', or 'Jump 3'."+cr

Dim OriginalThread = uCalc(uc_GetDefaultThread)
Dim _Prev As Table
Dim _Current As String, x As Long

uCalc Define Func:: SetVar(ByHandle Variable As AnyType, ByHandle Value As String) As Void _
     At ucAddr(uc_SetVariableValue)

uc_For(x, Asc("b"), Asc("p"), 1, _Prev("1"+Chr(x)) = "1"+Chr(x-1))
uc_For(x, Asc("b"), Asc("g"), 1, _Prev("2"+Chr(x)) = "2"+Chr(x-1))
uc_For(x, Asc("b"), Asc("f"), 1, _Prev("3"+Chr(x)) = "3"+Chr(x-1))
_Prev("2a") = "1p"
_Prev("3a") = "2g"

ucalc Syntax --{position}-- ::= SetVar(_Current, \q{position}\q)
uCalc Syntax Jump {position} ::= _
   SetInput("uCalc Load \qTutorial\q \q--{position}--\q") _
   SetInput("uCalc Exit Files")

uCalc Syntax Help ::= Cls ::: TutorialHelp
uCalc Syntax Continue ::= SetInput("uCalc Exit")
uCalc Syntax Quit ::= SetInput("uCalc Exit All")
ExitCommand = "uCalc Exit \qIf you want to exit the Tutorial completely press F10 (press Enter now first)\q Y"

' Keys 59 through 68 are F1 through F10
KeyExtCode(59) = "Help" + Chr(13)
KeyExtCode(60) = 'ShellExecute(0, "", "CMD.EXE", "/C Hh uCalcLB.chm", "", 0)' + Chr(13)
KeyExtCode(61) = 'ShellExecute(0, "", "CMD.EXE", "/C Hh Interpreter.chm", "", 0)' + Chr(13)
KeyExtCode(62) = 'Jump ~Eval(_Prev(_Current))' + Chr(13)
KeyExtCode(63) = "Continue" + Chr(13)
KeyExtCode(65) = "TableOfContents"+Chr(13)
KeyExtCode(68) = "uCalc Exit All" + Chr(13)

uCalc Echo "uCalc Language Builder Tutorial"
uCalc Echo "Copyright (C) 2007 by Daniel Corbier"
uCalc Echo "www.ucalc.com"
uCalc Echo ""
uCalc Echo "Welcome to the uCalc Language Builder tutorial.  You will be guided"
uCalc Echo "through a series concepts.  You will generally be given a series of"
uCalc Echo "examples (which are preceded by the > prompt) that you can enter"
uCalc Echo "(or paste) at the ucalc> prompt (do not paste the > symbol as part of"
uCalc Echo "the code).  You are encouraged to also experiment with your own lines"
uCalc Echo "of code related to the given examples.  Once you are ready for the next"
uCalc Echo "concept, type the word Continue at the uCalc prompt (or press F5)"
uCalc Echo "to move on.  You might find it useful to have the Interpreter and"
uCalc Echo "LB help files on hand to gain a deeper understanding of some concepts."
uCalc Echo ""
uCalc Echo "Type Continue (or press F5) to continue."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "The tutorial is divided into 3 sections.  Part 1 will familiarize you"
uCalc Echo "with the interactive interpreter.  In Part 2, you will look under the"
uCalc Echo "hood to see how everything the interpreter allowed you to do in Part 1"
uCalc Echo "was defined using the Language Builder; and how you can change things."
uCalc Echo "In Part 3, you will see how to borrow from, or create various languages"
uCalc Echo "as different as BASIC, Python, Logo, Forth, and Lisp."
uCalc Echo ""
uCalc Echo "If you are going through the tutorial in several sittings, then when you"
uCalc Echo "come back you will want to press F7 to see the table of contents, along"
uCalc Echo "with instructions on how to jump to the topic where you left off."
uCalc Echo ""
uCalc Echo "Before pressing F5 to continue, you may want to type Help (or press F1)"
uCalc Echo "to see a list of other useful options."
uCalc Echo ""
uCalc Echo "Type Continue (or press F5) to continue."
uCalc Session

--1--
--1a--
Cls
uCalc Echo "PART 1. The interpreter as a calculator / expression evaluator"
uCalc Echo ""
uCalc Echo "1a. General operators and functions you can use"
uCalc Echo "-----------------------------------------------"
uCalc Echo "Arithmetic:  +, -, *, /, ^, MOD, \ (integer divide), ! (factorial)"
uCalc Echo "Bitwise:  AND, OR"
uCalc Echo "Boolean:  AndAlso, OrElse"
uCalc Echo "Comparison (numeric & string):  >, <, <>, >=, <=, =="
uCalc Echo "Misc:  ABS, EXP, LOG, CEIL, SQR, INT, FRAC, SGN"
uCalc Echo "Misc2: MIN, MAX, IIF (these work with either strings or numbers)."
uCalc Echo "Trig:  SIN, COS, TAN, ATAN"
uCalc Echo "String:  + (concatenate)"
uCalc Echo "See the uCalc Interpreter help file (press F3) for more."
uCalc Echo ""
uCalc Echo "Type in arithmetic expressions such as:"
uCalc Echo ""
uCalc Echo "> 1+1"
uCalc Echo "> 3 + 4 * 5"
uCalc Echo "> (5.25+10)*3"
uCalc Echo ""
uCalc Echo "Experiment! Then type Continue for the next concept."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "You might find a few more functions useful, such as: Chr, Asc,"
uCalc Echo "Str, and Len.  Please refer to the uCalc Interpreter help file for"
uCalc Echo "details of how these particular functions work.  ResultStr returns"
uCalc Echo "the value of the last result as a string.  If the last expression was"
uCalc Echo "numeric, you can use Result.  Type examples such as the following (or"
uCalc Echo "if you're feeling lazy, simply copy/paste the following block of lines):"
uCalc Echo ""
uCalc Echo '> Chr(65) + Chr(66)'
uCalc Echo '> Asc("U")'
uCalc Echo '> "Number " + Str(123)'
uCalc Echo '> "Repeat of last result: " + ResultStr'
uCalc Echo '> Len("Hello " + "World")'
uCalc Echo '> Result * 10'
uCalc Echo ""
uCalc Echo "Experiment! Then type Continue for the next concept."
uCalc Echo ""
uCalc Session

--1b--
Cls
uCalc Echo "1b. Keyboard Shortcuts"
uCalc Echo ""
uCalc Echo "You can assign a string to any key.  For instance, if you want"
uCalc Echo '"Hello World" to be displayed whenever you press ? (question mark)'"
UCalc Echo "you can do this by entering (or pasting):"
uCalc Echo ""
uCalc Echo '> KeyCode(Asc("?")) = "Hello World"'
uCalc Echo ""
uCalc Echo "Experiment! Then type Continue for the next concept."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "Chances are you won't really want ? to do anything other than"
uCalc Echo "display ? .  So to restore a key back to itself, simply set its"
uCalc Echo "key code equal to an empty string like this:"
uCalc Echo ""
uCalc Echo '> KeyCode(63) = ""'
uCalc Echo ""
uCalc Echo "Note that 63 is the ASCII value of ? .  If you attempted to do"
uCalc Echo 'KeyCode(Asc("?")) = "" , the ? symbol would have been expanded and'
uCalc Echo 'you would end up with an unwanted: KeyCode(Asc("Hello World")) = ""'
uCalc Echo ""
uCalc Echo "Experiment! Then type Continue for the next concept."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "You can also set extended keys, such as F1, F2, F3, etc..."
uCalc Echo "by using KeyExtCode instead of KeyCode.  The codes for F1"
uCalc Echo "through F12 are 59 to 68."
uCalc Echo ""
uCalc Echo "By now, you might be tired of typing the word Continue each"
uCalc Echo "time.  To make things easier, let us assign the word Continue"
uCalc Echo "to F9.  From now on you can just press F9 whenever you are"
UCalc Echo "ready to move on."
uCalc Echo ""
uCalc Echo "> KeyExtCode(67) = 'Continue' + Chr(13)"
uCalc Echo ""
uCalc Echo "Experiment! Then press F9 to continue."
uCalc Echo ""
uCalc Echo "(Actually F5 is configured the same way at the beginning of"
uCalc Echo "Tutorial.uc, so you can press that too)."
uCalc Echo ""
uCalc Session

--1c--
Cls
uCalc Echo "1c. Defining things"
uCalc Echo ""
uCalc Echo "You can define functions, operators, variables, constants, syntax"
uCalc Echo "constructs, patterns, data types, or macros using one of the"
uCalc Echo "following keywords:"
uCalc Echo ""
uCalc Echo "Keyword      What it represents"
uCalc Echo "-------      ------------------"
uCalc Echo "Func         Function"
uCalc Echo "Op           Operator"
uCalc Echo "Var          Variable"
uCalc Echo "Const        Constant"
uCalc Echo "Syntax       Syntax construct"
uCalc Echo "Pattern      Character pattern"
uCalc Echo "DataType     Data type"
uCalc Echo "Macro        Text substitution macro"
uCalc Echo ""
uCalc Echo "The syntax is:"
uCalc Echo ""
uCalc Echo "uCalc Define {keyword}: {definition}"
uCalc Echo ""
uCalc Echo "Press F5 for examples."
uCalc Echo ""
uCalc Session

--1d--
Cls
uCalc Echo "1d. Variables"
uCalc Echo ""
uCalc Echo "> uCalc Define Var: MyVariable"
uCalc Echo "> uCalc Define Var: x = 123"
uCalc Echo "> uCalc Define Var: MyInt As Long"
uCalc Echo '> uCalc Define Var: MyString As String = "Hello "'
uCalc Echo ""
uCalc Echo "The above lines define (in order), a variable named MyVariable"
uCalc Echo "with the default data type (extended precision) and an implied"
uCalc Echo "starting value of 0; a variable x (also of default type), which"
uCalc Echo "is set with a starting value of 123; a variable named MyInt with"
uCalc Echo "a specified Long data type; and lastly a string variable with a"
uCalc Echo 'starting value of "Hello".'
uCalc Echo ""
uCalc Echo "Once you have defined these variables, you can use them in"
uCalc Echo "expressions, or assign new values to them.  For instance:"
uCalc Echo ""
UCalc Echo '> MyString + "world"'
uCalc Echo "> MyVariable = x * 2 + 0.5"
uCalc Echo "> MyVariable"
uCalc Echo "> MyInt = 100 / 3"
uCalc Echo "> MyInt"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo '"uCalc Define Var:" is rather verbose.  You can use the BASIC-like'
uCalc Echo '"Dim" statement as a shortcut.  "Dim" also has a couple of other'
uCalc Echo 'small advantages over "uCalc Define Var:".  With Dim you can define'
uCalc Echo "several variables on the same line, by separating them with commas."
uCalc Echo "It also supports a more convenient syntax for Table variables."
uCalc Echo "Items available under Var: but introduced in this section include:"
ucalc Echo "At {Address}, an array, Stack list variable, VarPtr, and more."
uCalc Echo ""
uCalc Echo "Press F5 to see examples."
uCalc Session
Cls
uCalc Echo "> Dim Price As Currency, MyTable As Table, D As Double = 125/100"
uCalc Echo '> Dim MyList As Stack = {12, "apple", {4, 5}, D}'
uCalc Echo "> Dim MyInt As Integer, MyWord As Word At VarPtr(MyInt)"
uCalc Echo "> Dim MyString(10) As String"
uCalc Echo "> "
uCalc Echo "> Price = 100/7"
uCalc Echo "> MyInt = -1"
uCalc Echo '> uc_For(x, 1, 10, 1, MyString(x) = "Number " + Str(x))'
uCalc Echo '> MyTable("Bird") = "Animal"'
uCalc Echo '> MyTable("Apple") = "Fruit"'
uCalc Echo '> MyTable("Pi") = 3.14'
uCalc Echo '> MyTable("TwoPi") = 3.14*2'
uCalc Echo "> "
uCalc Echo "> MyList"
uCalc Echo "> MyTable"
uCalc Echo '> MyTable("Apple")'
uCalc Echo '> Mytable("Pi")'
uCalc Echo "> MyString(3)"
uCalc Echo "> MyString(7)"
uCalc Echo "> MyInt"
uCalc Echo "> MyWord ' Note that MyWord was defined at the same address as MyInt"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo "The following examples define constants.  Subsequently attempting"
uCalc Echo "to assign a new value to these constants will result in an error."
uCalc Echo "The value assigned to a constant can be any expression.  The"
uCalc Echo "expression is not limited to arithmetic or other constants."
uCalc Echo ""
uCalc Echo "> uCalc Define Const: _Pi = Atan(1) * 4"
uCalc Echo '> uCalc Define Const: Title As String = "uCalc Tutorial"'
uCalc Echo ""
uCalc Echo "You can use Const by itself as a shortcut:"
uCalc Echo ""
uCalc Echo "> Const uc_Red = 1"
uCalc Echo "> Const uc_Blue = 2"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1e--
Cls
Dim pi = Atan(1)*4
uCalc Echo "1e. Function definitions"
uCalc Echo ""
uCalc Echo "The following function definitions demonstrate concepts such as"
uCalc Echo "recursion (factorial), overloading (2 defs for Twice; likewise for"
uCalc Echo "Area); optional argument (volume), and multi-statements (test):"
uCalc Echo ""
uCalc Echo "> uCalc Define Func: f(x) = x^2"
uCalc Echo "> uCalc Define Func: Twice(x As Double) As Double = x * 2"
uCalc Echo "> uCalc Define Func: Twice(x As String) As String = x + x"
uCalc Echo "> uCalc Define Func: Area(Number) = Number ^ 2"
uCalc Echo "> uCalc Define Func: Area(x, y) = x * y"
uCalc Echo "> uCalc Define Func: volume(r, h=0) = iif(h==0, pi*r^3*4/3, pi*r^2*h/3)"
uCalc Echo "> uCalc Define Func: Factorial(x) = iif(x>1, x*Factorial(x-1), 1)"
uCalc Echo "> uCalc Define Func: test(x As String)=Print(x+Chr(13)+Chr(10)) ::: Len(x)"
uCalc Echo "> "
uCalc Echo "> f(5)"
uCalc Echo "> Twice(123)"
uCalc Echo '> Twice("Hello ")'
uCalc Echo "> Factorial(10)"
uCalc Echo '> test("Good")'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1f--
Cls
Dim pi = Atan(1)*4
uCalc Echo "1f. Prefix shortcut"
uCalc Echo ""
uCalc Echo "To decrease verbosity, you can implicitly add a prefix to a group"
uCalc Echo "of definitions.  The definitions in the previous section (plus a"
uCalc Echo "couple more) can be rewritten in a simplified form like this"
uCalc Echo "(it's ok to re-define things):"
uCalc Echo ""
uCalc Echo '> uCalc Prefix "uCalc Define Func: "'
uCalc Echo ">    f(x) = x^2"
uCalc Echo ">    g(x, y) = x * y"
uCalc Echo ">    Twice(x As Double) As Double = x * 2"
uCalc Echo ">    Twice(x As String) As String = x + x"
uCalc Echo ">    Area(Number) = Number ^ 2"
uCalc Echo ">    Area(x, y) = x * y"
uCalc Echo ">    volume(r, h=0) = iif(h==0, pi*r^3*4/3, pi*r^2*h/3)"
uCalc Echo ">    Factorial(x) = iif(x>1, x*Factorial(x-1), 1)"
uCalc Echo ">    Fib(n) = IIf(n < 2, n, Fib(n-1) + Fib(n - 2))"
uCalc Echo ">    test(x As String) = Print(x+Chr(13)+Chr(10)) ::: Len(x)"
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1g--
Cls
uCalc Echo "1g. Bootstrapping a definition"
uCalc Echo ""
uCalc Echo "Earlier we defined Area(Number).  If you want that function to"
uCalc Echo "return an error if Number is smaller than zero, then you can"
uCalc Echo "extend the definition of Area by bootstrapping it as follows:"
uCalc Echo "(first be sure that Area was defined in the previous section)"
uCalc Echo ""
uCalc Echo "> uCalc Define Bootstrap ~~ Func: Area(Number) = _"
uCalc Echo ">    IIf(Number < 0, _"
uCalc Echo '>    uCalc(uc_SetErrorNumber, "", uc_Err_Float_Invalid_Operation), _'
uCalc Echo ">    Area(Number))"
uCalc Echo ""
uCalc Echo "Then try these:"
uCalc Echo ""
uCalc Echo "> Area(5)"
uCalc Echo "> Area(-10)"
uCalc Echo ""
uCalc Echo "Bootstrapping is generally more useful in situations where"
uCalc Echo "you do not have access to the original definition.  Instead"
uCalc Echo "of modifying the original definition, you can simply add to it."
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1h--
Cls
uCalc Echo "1h. Redefining a function"
uCalc Echo ""
uCalc Echo "So far, you have seen how a same function name can be re-used in a"
uCalc Echo "definition in the context of overloading, recursion, and bootstrapping."
uCalc Echo "It is also possible to create a new function that overshadows an older"
uCalc Echo "function of the same name.  The new version of the function will take"
uCalc Echo "effect in subsequent uses.  However, the old function remains in memory."
uCalc Echo "Items that were already defined using the old definition arn't affected."
uCalc Echo "Also, if you delete the new definition, the parser will revert back to"
uCalc Echo "the older definition for subsequent expressions."
uCalc Echo ""
uCalc Echo "> Func f(x) = 10 * x"
uCalc Echo "> Func g(x) = f(x) + 1"
uCalc Echo "> f(5)"
uCalc Echo "> g(5)"
uCalc Echo "> Func f(x) = 1000 * x"
uCalc Echo "> f(5)"
uCalc Echo "> g(5)"
uCalc Echo '> ReleaseItem("f")'
uCalc Echo "> f(5)"
uCalc Echo "> g(5)"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1i--
Cls
uCalc Echo "1i. Macro definitions"
uCalc Echo ""
uCalc Echo "A macro performs text substitution based on the argument(s)."
uCalc Echo "In some ways a macro is like a function.  But there are slight"
uCalc Echo "nuances, as the following examples show:"
uCalc Echo ""
uCalc Echo "> uCalc Define Macro: PlusMacro(x) = x + x"
uCalc Echo "> uCalc Define Func:  PlusFunc(x)  = x + x"
uCalc Echo "> "
uCalc Echo "> PlusMacro(5) * 2"
uCalc Echo "> PlusFunc(5) * 2"
uCalc Echo '> PlusMacro("Hello ")'
uCalc Echo '> PlusFunc("Hello ")'
uCalc Echo ""
uCalc Echo "Notice that the first line evaluates as 5 + 5 * 2."
uCalc Echo "The second line evaluates as (5 + 5) * 2."
uCalc Echo 'The third line evaluates as "Hello " + "Hello" (concatenation)'
uCalc Echo "The fourth line returns an error, because PlusFunc requires a"
uCalc Echo "numeric argument according to the way that function was defined."
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1j--
Cls
uCalc Echo "1j. Operator definitions"
uCalc Echo ""
uCalc Echo "There are three general types of operators you can define:"
uCalc Echo "Prefix (such as the unary minus - ), Postfix (the unary ! operator"
uCalc Echo "for factorial), and Infix (for operators like +, -, *, /)."
uCalc Echo ""
uCalc Echo "An operator definition usually starts with a precedence level (otherwise"
uCalc Echo "a default level is used).  What follows depends on whether you are"
uCalc Echo "defining a Prefix, Postfix, or Infix operator.  For prefix, after the"
uCalc Echo "precedence, you would have the operator itself (which can be alphanumeric,"
uCalc Echo "or a combination of symbols) followed by an operand within curly braces {}."
uCalc Echo "For postfix, the order of operator and operand are reversed.  For infix,"
uCalc Echo "you have operand 1, operator, then operand 2.  After that comes an equal"
uCalc Echo "sign = , and the actual definition."
uCalc Echo ""
uCalc Echo "Press F5 to see examples."
uCalc Session
Cls
uCalc Echo "The following three definitions, in order, are for a prefix ! operator"
uCalc Echo "that returns a true if the operand is 0, or false otherwise; a postfix"
uCalc Echo "percentage operator with the % symbol; and an infix operator named"
uCalc Echo "Plus that adds up the two operands.  The precedence level (50) for the"
uCalc Echo "first two is chosen somewhat arbitrarily, while the precedence for Plus"
uCalc Echo "is pegged at the same level as the + operator."
uCalc Echo ""
uCalc Echo "> uCalc Define Op: 50               !{x}         =  x == 0"
uCalc Echo "> uCalc Define Op: 50               {x}%         =  x / 100"
uCalc Echo '> uCalc Define Op: Precedence("+")  {x} Plus {y} = x + y'
uCalc Echo "> "
uCalc Echo "> !5"
uCalc Echo "> !(5-5)"
uCalc Echo "> 25%"
uCalc Echo "> 5 Plus 4"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1k--
Cls
uCalc Echo "1k. Windows API routines and other callbacks"
uCalc Echo ""
uCalc Echo "uCalc LB allows you to attach your function or operator"
uCalc Echo "definitions to pre-existing routines found in the Windows API,"
uCalc Echo "other DLL files, or your host program.  The key is to know the"
uCalc Echo "routine's prototype, and address.  The prototype syntax used"
uCalc Echo "here is BASIC-like, except at the end you add the word 'At'"
uCalc Echo "followed by the address of the routine."
uCalc Echo ""
uCalc Echo "Press F5 to see examples."
uCalc Session
Cls
uCalc Echo "Try these Windows API definitions:"
uCalc Echo ""
uCalc Echo "> uCalc Define func: _"
uCalc Echo '>    CharUpper(ByRef lpText As LPCSTR) As Dword At User32("CharUpperA")'
uCalc Echo "> "
uCalc Echo "> uCalc Define func: _"
uCalc Echo '>    MessageBeep(ByVal dwType As Dword) As Long At User32("MessageBeep")'
uCalc Echo "> "
uCalc Echo "> uCalc Define Func: _"
uCalc Echo ">    SetCursorPos(ByVal x AS Long, ByVal y As Long) As Long _"
uCalc Echo '>    At User32("SetCursorPos")'
uCalc Echo "> "
uCalc Echo '> Dim MyText As LPCSTR = "Hello There", x As Long'
uCalc Echo "> CharUpper(MyText)"
uCalc Echo "> MyText"
uCalc Echo "> MessageBeep(-1)"
uCalc Echo "> uc_For(x, 1, 600, 5, SetCursorPos(x, 200+sin(x*5)*30) ::: Sleep(40))"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad WinAPI.uc", "", 0)' + Chr(13)
uCalc Echo "The WinAPI.uc file (which you can open right now with Notepad by pressing F6"
uCalc Echo "so you can gain a better understanding), contains definitions for a few"
uCalc Echo "more API routines.  The syntax for declaring Windows APIs is partially"
uCalc Echo "defined there as well.  With the help of the MSDN, and/or a more complete"
uCalc Echo "WinAPI include file, you can add other definitions to the list."
uCalc Echo ""
uCalc Echo "Here are additional examples:"
uCalc Echo ""
uCalc Echo "> uCalc Define Const: MB_YESNO = 4"
UCalc Echo ">"
uCalc Echo '> MessageBox(0, "uCalc LB is pretty cool", "uCalc message", MB_YESNO)'
uCalc Echo '> SetConsoleTitle("uCalc LB Tutorial")'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1l--
Cls
uCalc Echo "1l. Callbacks from your host program"
uCalc Echo ""
uCalc Echo "uCalc FMP (which is a separate download from the Language Builder)"
uCalc Echo "contains examples of definitions based on callback functions"
uCalc Echo "located in the host program.  Callbacks are ordinary functions"
uCalc Echo "created with a compiler like PowerBASIC, VB, Delphi, VC++, etc...,"
uCalc Echo "which can be called from uCalc."
uCalc Echo ""
uCalc Echo "One example similar to what you'll find in the uCalc FMP VB demo"
uCalc Echo "looks something like this (please look at FMP for other kinds of"
uCalc Echo "examples):"
uCalc Echo ""
uCalc Echo "Function EasyFunc(ByVal a As Double, ByRef b As Long) As Double"
uCalc Echo "   EasyFunc = a + b"
uCalc Echo "End Function"
uCalc Echo ""
uCalc Echo 'ucDefineFunction "EasyFunc(ByVal a As Double, ByRef b As Long) As Double", _'
uCalc Echo '   AddressOf EasyFunc'
uCalc Echo ""
uCalc Echo "(you cannot use this example in the interpreter):"
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session

--1m--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Library.uc", "", 0)' + Chr(13)
uCalc Echo "1m. NativeCall callbacks"
uCalc Echo ""
uCalc Echo "uCalc LB supports a special category of callbacks that are defined"
uCalc Echo "differently from ordinary callbacks.  NativeCall routines directly"
uCalc Echo "match the way uCalc works internally.  Thus, they use less overhead"
uCalc Echo "and run more efficiently.  Most of the functions and operators"
uCalc Echo "found in Library.uc (Press F6 to view this file now) are defined"
uCalc Echo "this way.  Those definitions are pegged to routines that are"
uCalc Echo "compiled into the main LB DLL.  You can do the same with your own"
uCalc Echo "DLLs.  The distinguishing syntax is two colons :: instead of one"
uCalc Echo "following the words Func or Op."
uCalc Echo ""
uCalc Echo "The actual PowerBASIC source code for floating point multiplication"
uCalc Echo "as compiled in the LB DLL file looks like this:"
uCalc Echo ""
uCalc Echo "Sub Op_Multiply_Extended(Expr As ExpressionType)"
uCalc Echo "   Expr.@ResultExt = Expr.@LeftExt * Expr.@RightExt"
uCalc Echo "End Sub"
uCalc Echo ""
uCalc Echo "The corresponding definition from Library.uc is:"
uCalc Echo ""
uCalc Echo "uCalc Define Op:: 70 {x}*{y} At ucAddr(uc_Op_Multiply_Extended)"
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session

--1n--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Types.uc", "", 0)' + Chr(13)
uCalc Echo "1n. Defining / declaring data types"
uCalc Echo ""
uCalc Echo "uCalc LB comes with a library of handlers for data types such as: Byte,"
uCalc Echo "Word, Integer, Long, Dword, 64-bit integer, Single, Double, Extended,"
uCalc Echo "Currency, Ansi String, Unicode String, Fixed Length String, Null-"
uCalc Echo "terminated String, Void, Stack Type (from which can be derived List,"
uCalc Echo "Sorted List, Table, ...), as well as User Defined Types.  Browse through"
uCalc Echo "the Types.uc file (press F6 to view it now) to see how they are declared."
uCalc Echo "In addition to these, you can create handlers for your own special data"
uCalc Echo "types.  See the uCalc LB help file for details (press F2 for that file)."
uCalc Echo "The following example shows one way to create a user defined type:"
uCalc Echo "
uCalc Echo '> uCalc Prefix "uCalc Define "'
uCalc Echo '>    Begin'
uCalc Echo '>       DataType: MyUserType'
uCalc Echo '>       {Var: xLeft As Integer}'
uCalc Echo '>       {Var: xTop As Integer}'
uCalc Echo '>       {Var: xRight As Integer}'
uCalc Echo '>       {Var: xBottom As Integer}'
uCalc Echo '>       TypeHandler: ucAddr(uc_User_Type)'
uCalc Echo '>    End'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1o--
Cls
uCalc Echo "1o. Defining character patterns"
uCalc Echo ""
uCalc Echo "In the language builder, the grouping of characters that form alphanumeric"
uCalc Echo "words, numbers, quotation marks for strings, whitespace, symbols, etc..."
uCalc Echo "is not hard coded.  When you load the generic interpreter, by default"
uCalc Echo "it accepts single and double quotes as literal string quotation mark"
uCalc Echo "delimiters, and uses the same rules as languages such as BASIC for"
uCalc Echo "alphanumeric words.  You are free to change this.  Later on you will"
uCalc Echo "find the single quote pattern redefined in the Lisp language for a"
uCalc Echo "different use.  Also in Lisp the 'alphanumeric' pattern is redefined"
uCalc Echo "to include symbols such as +, -, *, etc...  Patterns define the units"
uCalc Echo "of text that the parser picks up for analysis.  Patterns are defined"
uCalc Echo "using 'regular expressions'.  See the uCalc LB help file (press F2 for"
uCalc Echo "this) for more details.  Also search the Internet for help on the"
uCalc Echo "concept of 'regular expressions'."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session
Cls
uCalc Echo "Defining character patterns (continued)"
uCalc Echo ""
uCalc Echo "The following arbitrary patterns define # as a string quote delimiter,"
uCalc Echo "as well as Quote / End Quote, and ; (semicolon) as statement separator, "
uCalc Echo "and !! (2 exclamations) followed by all characters up until the end of line"
uCalc Echo "as whitespace (making this work as a comment):"
uCalc Echo ""
uCalc Echo "> uCalc Define Pattern: # ~~ # ~~ _"
uCalc Echo ">    Properties: ucQuotedText + ucLiteral ~~ DataType: String"
uCalc Echo "> uCalc Define Pattern: Quote ~~ End Quote ~~ _"
uCalc Echo ">    Properties: ucQuotedText + ucLiteral ~~ DataType: String"
uCalc Echo "> uCalc Define Pattern: ; ~~ Properties: ucStatementSep"
uCalc Echo "> uCalc Define Pattern:!!.+ ~~ Properties: ucWhiteSpace"
uCalc Echo "> "
uCalc Echo "> #Hello#  + Quote World End Quote"
uCalc Echo "> Print('abc '); Print('xyz ') !! Old quotes are also still in effect"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--1p--
Cls
uCalc Echo "1p. Log files"
uCalc Echo ""
uCalc Echo "From time to time, you may want to save a log of your interactive"
uCalc Echo "uCalc session.  The following example creates a log file named"
uCalc Echo "MyLog.log, which will save a log of the next few lines until it"
uCalc Echo "reaches uCalc Log End.  See the uCalc Interpreter help file (press F3)"
uCalc Echo "for details on various ways of dealing with log files."
uCalc Echo ""
uCalc Echo '> uCalc Log "MyLog.log"'
uCalc Echo "> ' This is the first line to be logged"
uCalc Echo "> 1+1"
uCalc Echo "> 2+2"
uCalc Echo "> ' The next line will be the last one to appear in the log file."
uCalc Echo "> uCalc Log End"
uCalc Echo "> "
uCalc Echo "> ' This line will not be in the log file. "
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo "Now is a good moment to take a break!"
uCalc Echo ""
uCalc Echo "If you choose to stop the interpreter now and continue later, when"
uCalc Echo "you come back you can press F7 for the table of contents and jump"
uCalc Echo "directly to a given section.  F1 will give you a list of options."
uCalc Echo ""
uCalc Echo "Press a key when you are ready to continue."
UCalc Pause

--2--
--2a--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad uCalc.uc", "", 0)' + Chr(13)
uCalc Echo "PART 2. Underneath the hood of the Interpreter"
uCalc Echo ""
uCalc Echo "If you've been going through this tutorial sequentially, then most"
uCalc Echo "of what you have learned so far concerns the Interpreter, and not"
uCalc Echo "the language builder itself yet.  The interpreter represents just"
uCalc Echo "one kind of tool that can make use of uCalc Language Builder; one"
uCalc Echo "that happens to be useful in demonstrating some of the LB's features."
uCalc Echo "uCalc FMP (available at www.ucalc.com) is another.  Hopefully, by"
uCalc Echo "the end of this tutorial, you'll be able to think of even more uses."
uCalc Echo ""
uCalc Echo "Everything, ranging from the algebraic notation you have used so far"
uCalc Echo "in the interpreter, to the constructs that let you define your functions"
uCalc Echo "and variables, are part of a kind of arbitrarily designed generic language, "
uCalc Echo "which is constructed every time you run uCalc.Exe.  At startup, uCalc"
uCalc Echo "automatically loads uCalc.uc (press F6 to view it), which in turn loads"
uCalc Echo "other files with the .uc extension, across which can be found the"
uCalc Echo "definitions that make up this generic interpreter language."
uCalc Echo ""
UCalc Echo "These .uc files are plain text.  Take a moment now to browse through"
uCalc Echo "some of them to get a feel for what they do.  In this section of the"
uCalc Echo "tutorial, we will revisit the constructs discussed in PART 1, and"
uCalc Echo "see how they were defined and how they can be modified."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session

--2b--
Cls
uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))
KeyExtCode(63) = "uCalc Eval Continue" + Chr(13)
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad RPN.uc", "", 0)' + Chr(13)

uCalc Echo "2b. Math notation"
uCalc Echo ""
uCalc Echo "PART 1 started out by listing operators and functions that you could"
uCalc Echo "use, then gave a few examples of arithmetic expressions written in"
uCalc Echo "algebraic (infix) notation.  However the LB itself has no preference"
uCalc Echo "for a particular kind of notation.  You could just as easily make it"
uCalc Echo "work with RPN (Reverse Polish Notation) instead.  A small file named"
uCalc Echo "RPN.uc was created to do just that (press F6 to view it).  Take a"
uCalc Echo "brief moment to browse through that file.  Once you load it,"
uCalc Echo "an expression such as 3+4*5 would return an error.  The correct"
uCalc Echo "notation for that would be:  3 4 5 * +"
uCalc Echo ""
uCalc Echo "Note: In this section of the tutorial, the emphasis is more on"
uCalc Echo "demonstrating that it is possible to modify things, and not so much"
uCalc Echo "on how it's done.  Don't worry about understanding all the details"
uCalc Echo "just yet.  The last section will more directly explain the language"
uCalc Echo "builder concepts that will help you understand the details."
uCalc Echo ""
uCalc Echo '> uCalc Load "RPN"'
uCalc Echo "> 3 4 5 * +"
uCalc Echo "> 5.25 10 + 3 *"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

uCalc Prefix ""
uCalc(uc_SetDefaultThread, "", OriginalThread)
MainPrompt      = "ucalc> "
MultiLinePrompt = "ucalc>>"
KeyExtCode(63) = "Continue" + Chr(13)

--2c--
Cls
uCalc Echo "2c. Another thread"
uCalc Echo ""
uCalc Echo "Now we are back in the previous algebraic notation mode (try some"
uCalc Echo 'expressions to verify this).  The RPN "Language" was loaded into a'
uCalc Echo "separate thread.  If you examine the Tutorial.uc file, you will notice"
uCalc Echo "that these two lines were used prior to the RPN section (the first line"
uCalc Echo "is towards the beginning of the file):"
uCalc Echo ""
uCalc Echo "Dim OriginalThread = uCalc(uc_GetDefaultThread)"
uCalc Echo 'uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))'
uCalc Echo ""
uCalc Echo "Then after the RPN session, the RPN prefix is removed, the default"
uCalc Echo "thread is restored to the original one (which uses algebraic notation),"
uCalc Echo "and the prompts are restored to their previous state like this:"
uCalc Echo ""
uCalc Echo 'uCalc Prefix ""'
uCalc Echo 'uCalc(uc_SetDefaultThread, "", OriginalThread)'
uCalc Echo 'MainPrompt      = "ucalc> "'
uCalc Echo 'MultiLinePrompt = "ucalc>>"'
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session

--2d--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Library.uc", "", 0)' + Chr(13)
uCalc Echo "2d. Library.uc"
uCalc Echo ""
uCalc Echo "All of the operators and functions listed at the beginning of the"
uCalc Echo "tutorial are defined in Library.uc.  Take a brief moment to examine"
uCalc Echo "that file.  None of the definitions are sacred.  You can create your own"
uCalc Echo "DLL with your own new and improved versions of those routines.  Or you"
uCalc Echo "can remove, modify, or replace any of them, or add entirely new"
uCalc Echo "routines to the list.  Lets do some of that here."
uCalc Echo ""
uCalc Echo "Press F6 to view Library.uc.  Then press F5 to continue."
uCalc Session

--2e--
Cls
Dim x
uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))

uCalc Echo "2e. Here, we will rename the COS function to COSINE; delete the SGN"
uCalc Echo "function; make SINE synonymous with SIN; create a new COT function;"
uCalc Echo "replace the CEIL definition with one that multiplies the argument"
uCalc Echo "by 100; make MAX work with an indefinite number of arguments"
uCalc Echo "(instead of just two); create an alternative * operator for strings;"
uCalc Echo "define the & operator as a string concatenation operator, without"
uCalc Echo "making it the same as + (which would also work with numbers); and"
uCalc Echo "expand EXP to arbitrarily make it return an error for x > 100;"
uCalc Echo ""
uCalc Echo '> RenameItem("COS", "COSINE")'
uCalc Echo '> ReleaseItem("SGN")'
uCalc Echo "> uCalc Define Macro: SINE(x) = SIN(x)"
uCalc Echo "> uCalc Define Func: COT(x) = 1 / TAN(X)"
uCalc Echo "> uCalc Define Func: CEIL(x) = x*100"
uCalc Echo "> Syntax Max({a}, {b}, {More}) ::= Max({a}, Max({b}, {More}))"
uCalc Echo '> uCalc Define Op: Precedence("*") {s As String} * {count} As String _'
uCalc Echo '>    = _ToStr="":::uc_For(x, 1, count, 1, _ToStr = _ToStr+s)::: _ToStr'
uCalc Echo "> uCalc Define Op:: {x As String} & {y As String} As String _"
uCalc Echo ">    At ucAddr(uc_Op_StrConcat)"
uCalc Echo "> uCalc Define Bootstrap ~~ Func: _"
uCalc Echo '>    Exp(x) = IIf(x > 100, uCalc(uc_SetErrorNumber, "", _'
uCalc Echo ">    uc_Err_Float_Invalid_Operation), Exp(x))"
uCalc Echo ""
uCalc Echo "Paste the above block of lines, then press F5 to continue."
uCalc Session
Cls
uCalc Echo "Now that you have modified a set of routines, here are a few"
uCalc Echo "expressions to play with (Cos(5) and Exp(500) will return errors"
uCalc Echo "based on the modifications)"
uCalc Echo ""
uCalc Echo "> COS(5)"
uCalc Echo "> COSINE(5)"
uCalc Echo "> SIN(5)"
uCalc Echo "> SINE(5)"
uCalc Echo "> Exp(50)"
uCalc Echo "> Exp(500)"
uCalc Echo "> MAX(5, 23, 88, 11)"
uCalc Echo '> "Very " * 3 & "Nice"'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls

uCalc(uc_SetDefaultThread, "", OriginalThread)

uCalc Echo "The previous definitions were temporarily defined in another"
uCalc Echo "thread.  The original thread is now restored, so now we are"
uCalc Echo "back with the original definitions.  The COS that was renamed"
uCalc Echo "to COSINE wasn't a definition, so the renamed item belonged to"
uCalc Echo "the parent thread, and needs to be renamed back.  Try the same examples:"
uCalc Echo ""
uCalc Echo '> RenameItem("COSINE", "COS")'
uCalc Echo "> "
uCalc Echo "> COS(5)     ' This line now works again"
uCalc Echo "> COSINE(5)  ' This one returns an error"
uCalc Echo "> SIN(5)"
uCalc Echo "> SINE(5)    ' Returns an error"
uCalc Echo "> Exp(50)"
uCalc Echo "> Exp(500)   ' This works again"
uCalc Echo "> MAX(5, 23, 88, 11)    ' This no longer works"
uCalc Echo \q> "Very " * 3 & "Nice"  ' Neither does this\q
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Library.uc", "", 0)' + Chr(13)
uCalc Echo "In the first section, these additional useful functions were mentioned:"
uCalc Echo "Chr, Asc, Len, and Str.  In the Library.uc file (press F6 to view it),"
uCalc Echo "the Str function is defined as follows, where SpecialString is a data"
uCalc Echo "type defined in Types.uc and makes use of ConvertsFrom, and the second"
uCalc Echo "line returns the same string if the argument is already a string:"
uCalc Echo ""
uCalc Echo "uCalc Define Func: Str(AnyItem As SpecialString) As String = AnyItem"
uCalc Echo "uCalc Define Func: Str(StringItem As String) As String = StringItem"
uCalc Echo ""
uCalc Echo "The Len function, which returns the number of characters in a string"
uCalc Echo "is defined by using the Windows API routine SysStringByteLen, which is"
uCalc Echo "defined in WinAPI.uc, and passing it the BSTR address obtained from"
uCalc Echo "32-bit address pointed to (ValueAtAddr) by the value at the memory"
uCalc Echo "address of the string argument (VarPtr):"
uCalc Echo ""
uCalc Echo "Len(T As String) As Long = SysStringByteLen(ValueAtAddr(DWORD, VarPtr(T)))"
uCalc Echo ""
uCalc Echo "The Chr function can be expanded a la PowerBASIC such that it can"
uCalc Echo "take a string of arguments so that Chr(a, b, c) is equivalent to"
uCalc Echo "Chr(a) + Chr(b) + Chr(c):"
uCalc Echo ""
uCalc Echo "> uCalc Syntax Chr({first}, {rest}) ::= Chr({first}) + Chr({rest})"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Interp.uc", "", 0)' + Chr(13)
uCalc Echo "Earlier, we described KeyCode.  There is nothing magical about it.  It"
uCalc Echo "is simply an array that is defined in Interp.uc (press F6 to view it)"
uCalc Echo "as follows:"
uCalc Echo ""
uCalc Echo "uCalc Define Var: KeyCode(255) As String At ucAddr(uc_Interp_KeyCode)"
uCalc Echo ""
uCalc Echo "You can create an alternative array at the same location like this:"
uCalc Echo ""
uCalc Echo "> uCalc Define Var: MyKey(255) As String At ucAddr(uc_Interp_KeyCode)"
uCalc Echo ""
uCalc Echo "This definition overlays the MyKey string array on top of the"
uCalc Echo "address of an internal KeyCode array within uCalc.Exe."
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--2f--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Define.uc", "", 0)' + Chr(13)
uCalc Echo "2f. Defining a definition construct"
uCalc Echo ""
uCalc Echo "In PART 1, there were explanations on how to define functions"
uCalc Echo "and variables.  The construct for these definitions had a BASIC-like"
uCalc Echo "flavor.  However, it could have been made more C-like or Pascal-like."
uCalc Echo "You have complete control over the construct for defining things."
uCalc Echo "Not one word or syntax construct in the following line is native to"
uCalc Echo "the language builder:"
uCalc Echo ""
uCalc Echo '> uCalc Define Var: MyString As String = "Hello"'
uCalc Echo ""
uCalc Echo "uCalc is a keyword for the interpreter (but not LB).  Define is an"
uCalc Echo "interpreter keyword as well.  It matches the uc_Define command of"
uCalc Echo "the LB.  All the rest is part of a construct defined in Define.uc"
uCalc Echo "(press F6 and take a brief moment now to inspect that file).  The"
uCalc Echo "construct in that file expands the above line to the following"
uCalc Echo "sequence of simple property settings before uCalc LB can understand it:"
uCalc Echo ""
uCalc Echo 'uCalc Define Variable ~~ Name: MyString ~~ DataType: String ~~ Value: "Hello"'
uCalc Echo ""
uCalc Echo "See the Define topic of the uCalc LB help file."
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--2g--
Cls
uCalc Echo "2g. Expanding an expression"
uCalc Echo ""
uCalc Echo "Enter the following lines to see how the following definitions are"
uCalc Echo "expanded based on the constructs in Define.uc:"
uCalc Echo ""
uCalc Echo '> uCalc Expand Var: MyString As String = "Hello"'
uCalc Echo "> uCalc Expand Func: F(x As Long, y As Long = 0) As Long = x * y"
uCalc Echo '> uCalc Expand Op: Precedence("+") {x} Plus {y} = x + y'
uCalc Echo "> uCalc Expand Macro: Plus_Macro(x) = x + x"
uCalc Echo "> uCalc Expand Const: Pi = Atan(1) * 4"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--3--
--3a--
Cls
' Languages to consider tcl, Prolog, Math lang, unit, C, Pascal, Lua,
' Python, Logo, BASIC, (FORTH), LISP, Ruby, XML, MATHML, Symbolic,
' Haskell, Perl"

uCalc Echo "PART 3 Adding language flavors / Constructing a language"
uCalc Echo ""
uCalc Echo "Eventually, we will consider the construction of entire languages."
uCalc Echo "For now, let us start by simply adding syntax flavors."
uCalc Echo ""
uCalc Echo "These code snippets are not meant to be complete.  Hopefully you will"
uCalc Echo "find countless ways to improve the examples."
uCalc Echo ""
uCalc Echo "Regular Expressions are used often in the following sections."
uCalc Echo "If you are not familiar with the concept, a Google search for"
uCalc Echo '"Regular Expressions" will lead you to plenty of documentation for it.'
uCalc Echo ""
uCalc Echo "You do not need to be know the language being discussed in order to"
uCalc Echo "benefit from the section that talks about it."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session

--3b--
Cls
' Reference: docs.python.org/tut/node5.html
uCalc Echo "3b. Python flavor"
uCalc Echo ""
uCalc Echo "In the Python language, a comment is denoted by # and everything that"
uCalc Echo "follows.  The following syntax construct replaces text denoted by the"
uCalc Echo 'regular expression "#.*" (which means its a comment) with nothing:'
uCalc Echo ""
uCalc Echo '> uCalc Syntax {Comment:"#.*"} ::='
uCalc Echo ""
uCalc Echo "Python has an interesting construct where you can return a string,"
uCalc Echo "MyString, repeated n number of times ie: MyString * n."
uCalc Echo "Here's one way to define the operator for this:"
uCalc Echo ""
uCalc Echo '> uCalc Define Op: Precedence("*") {s As String} * {count} As String _'
uCalc Echo ">    = uc_For(x, 1, count, 1, _ToStr = _ToStr + s) ::: _ToStr"
uCalc Echo ""
uCalc Echo "Paste these then press F5 to continue (examples come at the end)."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "Python can concatenate consecutive strings ie: 'abc' 'cde' ==> 'abcde'."
uCalc Echo "The following construct does this by taking the first literal string,"
uCalc Echo "which is given the syntax name string1 and denoted by the regular"
uCalc Echo "expression ['][^']+['] , followed by one or more spaces denoted by [ ]+"
uCalc Echo "and string2, which is similar to string1, and replaces this all with"
uCalc Echo "{string1} + {string2}"
uCalc Echo ""
uCalc Echo \q> uCalc Syntax {string1:"['][^']+[']"} _\q
uCalc Echo \q>              {"[ ]+"}                _\q
uCalc Echo \q>              {string2:"['][^']+[']"} _\q
uCalc Echo \q>          ::= {string1} + {string2}\q
uCalc Echo ""
uCalc Echo "Paste this then press F5 to continue (examples come at the end)."
uCalc Echo ""
uCalc Session
Cls
uCalc Echo "Python has an interesting string subscript notation.  For instance if"
uCalc Echo "MyVar = 'Computer' you can retrieve characters or subsections of the"
uCalc Echo "string with things like MyVar[3], MyVar[2:4] MyVar[3:], etc...  In"
uCalc Echo "the following definitions StrPtr() returns the address of the string"
uCalc Echo "variable text;  uc_Peek() retrieves a string from the address given"
uCalc Echo "by the first argument, of a size given by the second argument.  100,"
uCalc Echo "which precedes each definition is a precedence level that is higher"
uCalc Echo "than levels assigned to arithmetic operators in Library.uc; the"
uCalc Echo "underscore character _ is for line continuation."
uCalc Echo ""
uCalc Echo '> uCalc Prefix "uCalc Define Syntax: "'
uCalc Echo '>    100 {string} {"\["} {index} {"\]"} _'
uCalc Echo '>        ::= uc_Peek(StrPtr({string})+{index}, 1)'
uCalc Echo '>    100 {string} {"\["} {start} {"\:\]"} _'
uCalc Echo '>        ::= uc_Peek(StrPtr({string})+{start}, Len({string})-{start})'
uCalc Echo '>    100 {string} {"\["} {start} : {end} {"\]"} _'
uCalc Echo '>        ::= uc_Peek(StrPtr({string})+{start}, {end}-{start}+1)'
uCalc Echo '>    100 {string} {"\[\:"} {index} {"\]"} _'
uCalc Echo '>        ::= uc_Peek(StrPtr({string}), {index}+1)'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Paste this then press F5 to continue (examples come at the end)."
uCalc Session
Cls
Dim MyString As String
uCalc Echo "If you have pasted all the Python definition lines, you can now"
uCalc Echo "play with the following code (Note: the first character has an"
uCalc Echo "index of 0):"
uCalc Echo ""
uCalc Echo "> MyString = 'Computer'"
uCalc Echo "> MyString"
uCalc Echo "> MyString * 5"
uCalc Echo "> MyString[4]              # returns u"
uCalc Echo "> MyString[:4]             # returns Compu"
uCalc Echo "> MyString[3:]             # what does this return?"
uCalc Echo "> MyString[2:5]"
uCalc Echo "> 'Hello '  'World'"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--3c--
Cls
uCalc Echo "3c. BASIC flavor"
uCalc Echo ""
uCalc Echo "Let's start with straight-forward constructs.  In BASIC the"
uCalc Echo "hexadecimal number AE5 can be written &hAE5, and a binary"
uCalc Echo "number such as 110111 is written &b110111.  Paste the following:"
uCalc Echo ""
uCalc Echo '> uCalc Prefix "uCalc Syntax "'
uCalc Echo '> 99   &{"b"}{BinaryNumber:"[0-1]+"} ::= BaseConvert("{BinaryNumber}", 2)'
uCalc Echo '> 99   &{"o"}{OctalNumber:"[0-7]+"}  ::= BaseConvert("{OctalNumber}",  8)'
uCalc Echo '> 99   &{"h"}{HexNumber:"[0-9A-F]+"} ::= BaseConvert("{HexNumber}",   16)'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Now you can enter expressions such as:"
uCalc Echo ""
uCalc Echo "> &hAE5"
uCalc Echo "> &b110111"
uCalc Echo "> &b1110011 OR &b1000010"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo "One quintessential BASIC construct is the PRINT statement, which"
uCalc Echo "allows you to display on screen a list of string and numeric data."
uCalc Echo "A semi-colon causes the next data to be displayed immediately after"
uCalc Echo "the previous one, while a comma causes it to be displayed in the"
uCalc Echo "next print zone.  Here we also define the Locate statement."
uCalc Echo ""
uCalc Echo '> RenameItem("Print", "_Print")'
uCalc Echo '> '
uCalc Echo '> uCalc Prefix "uCalc Syntax "'
uCalc Echo '> 20 Print [{data}] ::= _Print({data: Str({data}) +} Chr(13) + Chr(10))'
uCalc Echo '> 20 Print [{data}], [{etc}] ::= _'
uCalc Echo '>      {data: _Print(Str({data})) : } NextPrintZone() {etc: : Print {etc}}'
uCalc Echo '> 20 Print {data} ; [{etc}] ::= _Print(Str({data}))  {etc: : Print {etc}}'
uCalc Echo '> 20 _Print(Str({data}, {etc})) _'
uCalc Echo '>      ::= _Print(Str({data})) : NextPrintZone() : _Print(Str({etc}))'
uCalc Echo '> 20 Locate {row} [, {col=CursorX}] _'
uCalc Echo '>      ::= _Coord.x = {col}-1 : _Coord.y = {row}-1 _'
uCalc Echo '>      : SetConsoleCursorPosition(StdOut, _Coord)'
uCalc Echo '> 20 Locate , {col} _'
uCalc Echo '>      ::= _Coord.x = {col}-1 : _Coord.y = CurSorY-1 _'
uCalc Echo '>      : SetConsoleCursorPosition(StdOut, _Coord)'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Paste the above code, then press F5 for an explanation (examples come later)."
uCalc Session
Cls
uCalc Echo "Library.uc already has a function named Print(), which we also needed."
uCalc Echo "However, in order to create our new Print construct, it was necessary"
uCalc Echo "to rename the old Print to _Print.  Following that came a block of"
uCalc Echo "syntax code.  The number 20 arbitrarily represents a precedence level"
uCalc Echo "that is lower than that of operators found in Library.uc.  The syntax"
uCalc Echo "lines consist of a construct to the left of ::= , and the code it is"
uCalc Echo "transformed to on the right.  You will notice multiple rules, spanning"
uCalc Echo "several lines, to cover the comma-delimiter, semicolon, etc...  We"
uCalc Echo "also defined a typical BASIC Locate statement, which is part of the"
uCalc Echo "Print construct, as you'll see further down."
uCalc Echo ""
uCalc Echo "The code in the previous section only defines the syntax.  You will"
uCalc Echo "notice that functions named NextPrintZone(), CursorX, and CursorY"
uCalc Echo "were used.  So were variables _ScrBuff and _Coord.  These need to be"
uCalc Echo "defined.  While we're at it, we will define the colon : as the"
uCalc Echo "familiar BASIC statement separator as opposed to (or in addition to)".
uCalc Echo "::: , which is defined in Define.uc.  CursorX and CursorY, which would"
uCalc Echo "be familiar to PowerBASIC/CC users return the current column and row"
uCalc Echo "locations of the cursor on the screen. These are defined with Windows"
uCalc Echo "API routines declared in WinAPI.uc."
uCalc Echo ""
uCalc Echo "Press F5 to see the code."
uCalc Session
Cls
uCalc Echo '> uCalc Define Pattern: : ~~ Properties: ucStatementSep'
uCalc Echo '> uCalc Define Pattern: ::: ~~ Properties: ucStatementSep'
uCalc Echo '> '
uCalc Echo '> Dim _ScrBuff As CONSOLE_SCREEN_BUFFER_INFO'
uCalc Echo '> Dim _Coord As COORD'
uCalc Echo '> '
uCalc Echo '> uCalc Prefix "uCalc Define Func: "'
uCalc Echo '>    CursorX() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff) _'
uCalc Echo '>       : _ScrBuff.dwCursorPosition.x+1'
uCalc Echo '>    CursorY() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff) _'
uCalc Echo '>       : _ScrBuff.dwCursorPosition.y+1'
uCalc Echo '>    NextPrintZone() As Void = Locate , (CursorX+15)\14*14'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Copy/Paste the above code, then press F5 to try the examples."
uCalc Session
Cls
uCalc Echo "Try expressions such as these:"
uCalc Echo ""
uCalc Echo '> Print 3, 4, "Abc"; "Xyz",, "The End"'
uCalc Echo '> Print 5 : Print 6'
uCalc Echo '> Print 5; : Print 6'
uCalc Echo "> Print"
uCalc Echo '> Print : Print : Print 120/5, 2+4; : Print "Hello " + "world"'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo "Another useful BASIC construct is the For/Next loop.  So far, we"
uCalc Echo "have dealt with a uc_For() loop function.  We will now use this to"
uCalc Echo "define a BASIC-like For/Next.  In fact we'll define two versions of"
uCalc Echo "For/Next; the first is a multi-line construct, and the second is a"
uCalc Echo "single-line construct.  ~mStart and ~mEnd are defined in Define.uc"
uCalc Echo "as partial code block delimiters, which are useful for multi-line"
uCalc Echo "definitions."
uCalc Echo ""
uCalc Echo '> uCalc Prefix "uCalc Syntax "'
uCalc Echo '> 10   For {Var} = {Start} To {Stop} [Step {Step=1}] _'
uCalc Echo '>         ::= ~mStart uc_For({Var}, {Start}, {Stop}, {Step},'
uCalc Echo '> 10   Next ::= ) ~mEnd'
uCalc Echo '> '
uCalc Echo '> 15   For {Var} = {Start} To {Stop} [Step {Step=1}] : {Code} : Next _'
uCalc Echo '>         ::= uc_For({Var}, {Start}, {Stop}, {Step}, {Code})'
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Copy/Paste the above code, then press F5 to try the examples."
uCalc Session
Cls
uCalc Echo "For a better feel for the interactive nature of multi-line definitions,"
uCalc Echo "type the following examples instead of pasting them:"
uCalc Echo ""
uCalc Echo "Dim x As Long"
uCalc Echo ""
uCalc Echo "For x = 1 to 10"
uCalc Echo "   Print x, x^2"
uCalc Echo "Next"
uCalc Echo ""
uCalc Echo "For x = 20 to 100 step 5 : Print x : Next"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
Cls
uCalc Echo "Another useful BASIC construct is Type/End Type for user-defined"
uCalc Echo "type definitions.  We will use a different method for defining"
uCalc Echo "multi-line constructs than what was used for For/Next.  Here, we"
uCalc Echo "rely on the underscore line-continuation character _ (defined in"
uCalc Echo "uCalc.uc), and make it concatenate several parts of the definition"
uCalc Echo "onto one line before it is interpreted.  Here we'll introduce the"
uCalc Echo "SetInput function, which can feed lines of code to the interpreter"
uCalc Echo "before returning interactive control to the user."
uCalc Echo ""
uCalc Echo '> Dim _Type As String'
uCalc Echo '> uCalc Prefix "uCalc Syntax "'
uCalc Echo '>  Type {name} ::= _'
uCalc Echo '>   SetInput("  _") : _'
uCalc Echo \q>   SetInput("uCalc Prefix '_UDT: '") : _\q
uCalc Echo \q>   SetInput("_Type = 'DataType: {name} ~~'")\q
uCalc Echo '>  _UDT: {member} As {type} ::= _ '
uCalc Echo '>   SetInput("  _") : _'
uCalc Echo \q>   SetInput("uCalc Eval _Type = _Type + '{Var: {member} As {type}} ~~'")\q
uCalc Echo '>  _UDT: End Type ::= _'
uCalc Echo '>   SetInput("uCalc Define "+_Type+"TypeHandler: ucAddr(uc_User_Type)") _'
uCalc Echo \q>   : SetInput("uCalc Prefix ''")\q
uCalc Echo '> uCalc Prefix ""'
uCalc Echo ""
uCalc Echo "Copy/Paste the above code, then press F5 to try the examples."
uCalc Session
Cls
uCalc Echo "Play with these examples:"
uCalc Echo ""
uCalc Echo "> Type MyType"
uCalc Echo ">    a As Byte"
uCalc Echo ">    b As Byte"
uCalc Echo "> End Type"
uCalc Echo "> "
uCalc Echo "> Dim Test As MyType"
uCalc Echo "> "
uCalc Echo "> Test.a = 123"
uCalc Echo "> Test.b = Test.a * 2"
uCalc Echo "> "
uCalc Echo "> Print Test.a, Test.b"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session
RenameItem("_Print", "Print")
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad BASIC.uc", "", 0)' + Chr(13)
uCalc Echo "Using some of the techniques discussed so far, plus a few more"
uCalc Echo "advanced ones, for which you may need to browse through the help"
uCalc Echo "file to gain a better understanding, you can now construct a more"
uCalc Echo "complete version of BASIC.  A startup version of BASIC is included"
uCalc Echo "in the BASIC.uc file (press F6 to view it).  It is far from complete"
uCalc Echo "but has enough constructs to get you going.  Try to see what you can"
uCalc Echo "add to it.  Next time, you can load basic either by running the Basic.Bat"
uCalc Echo 'batch file from the Windows command prompt, or uCalc Load "BASIC.uc"'
uCalc Echo "from the uCalc prompt."
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

--3d--
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad RPN.uc", "", 0)' + Chr(13)
uCalc Echo "3d. The Forth language"
uCalc Echo ""
uCalc Echo "There's a good chance you might not be too familiar with the Forth"
uCalc Echo "programming language.  If so, don't worry.  As far as languages go,"
uCalc Echo "it is relatively easy to learn, and worth it; since the stack-based"
uCalc Echo "approach that this language uses, as well as the methods used in"
uCalc Echo "building a uCalc version of it can come in handy in other languages"
uCalc Echo "you may want to construct.  A good tutorial for the Forth language"
uCalc Echo "can be found at www.softsynth.com/pforth/pf_tut.htm .  Basically,"
uCalc Echo "I went through this tutorial, and learned Forth while simultaneously"
uCalc Echo "working on a uCalc version of it that allowed me to run the examples"
uCalc Echo "given in the tutorial."
uCalc Echo ""
uCalc Echo "Earlier on, we discussed the RPN.uc file (press F6 if you need to open"
uCalc Echo "that file again for inspection), which turns the interpreter into an"
uCalc Echo "RPN-mode calculator.  Forth uses this same stack-based RPN mode."
uCalc Echo "The code in the small RPN.uc can serve as a conceptual starting point."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session
Cls
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Forth.uc", "", 0)' + Chr(13)
uCalc Echo "A working version of Forth can be loaded into the uCalc interpreter"
uCalc Echo "from the Forth.uc file (uCalc Load 'Forth.uc').  For now, view this"
uCalc Echo "file by pressing F6 and follow along.  The RPN file already shows"
uCalc Echo "the code for placing numbers on the stack.  Now, if you are also"
uCalc Echo "looking at the Forth tutorial mentioned earlier, one of the early"
uCalc Echo "things that are mentioned is the dot (.) word, which returns (and pops)"
uCalc Echo "the value that's at the top of the stack.  The code for this can be"
uCalc Echo "found in line 63 of Forth.uc, which goes something like this:"
uCalc Echo ""
uCalc Echo "Def . --> Print(ToStr(Pop) + \q \q)"
uCalc Echo ""
uCalc Echo "It might be interesting to note that not a single character in the"
uCalc Echo "above line represents a built-in uCalc construct.  So let's unpack"
uCalc Echo "what everything in that line means.  Earlier on, we used a more uCalc-"
uCalc Echo "specific way of defining things: 'uCalc Syntax ... ::= ...'"
uCalc Echo "In the above line we instead used: 'Def ... --> ...'"
uCalc Echo "This new definition construct is defined in lines 27-29 of Forth.uc."
uCalc Echo "Without this simplification, the above Def line, as well as others"
uCalc Echo "would have to be defined more verbosely, something like this:"
uCalc Echo ""
uCalc Echo "uCalc Syntax FORTH . [{rest:\q .+\q}]::=Print(ToStr(Pop)+\q \q):::FORTH {rest}"
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session
Cls
uCalc Echo "Def . --> Print(ToStr(Pop) + \q \q)"
uCalc Echo ""
uCalc Echo "Continuing with the same line we were working on, the dot (.) word"
uCalc Echo "is what we are currently defining.  It uses the Print() function to"
uCalc Echo "output the value that's at the top of the stack, which is returned by"
uCalc Echo "the Pop function, which is first converted to a string with ToStr()."
uCalc Echo "\q is a quote symbol defined in Define.uc, which is in addition to"
uCalc Echo "the single quote and double quote characters, allowing for quotes"
uCalc Echo "within quotes nested several levels deep."
uCalc Echo ""
uCalc Echo "The next word defined in the Forth tutorial is '.S' .  This is defined"
uCalc Echo "in line 65 of Forth.uc.  It runs a uc_For loop, which displays each"
uCalc Echo "value on the stack in turn.  Then there are the parenthesis, which in"
uCalc Echo "Forth are used for comments.  This is defined in line 61 of Forth.uc."
uCalc Echo "This particular definition relies on a 'Regular Expression' definition"
uCalc Echo "that captures everything in parenthesis.  It is replaced with nothing."
uCalc Echo "Then there is 0SP, defined in line 72.  It uses the uc_For loop to"
uCalc Echo "remove everything off of the stack.  Then there is the DUP word,"
uCalc Echo "defined simply as Push(Read).  It reads the value at the top of the"
uCalc Echo "stack, and pushes a copy of what it just read on top of the stack,"
uCalc Echo "in effect creating a duplicate."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session
Cls
uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))
KeyExtCode(63) = "uCalc Exit" + Chr(13)
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Test\Forth.in", "", 0)' + Chr(13)
uCalc Echo "The Forth language (continued)"
uCalc Echo ""
uCalc Echo "Once we've reached the point where we can define something like DUP,"
uCalc Echo "we can basically run down the Forth tutorial and add new definitions"
uCalc Echo "the same way as we go along, using a combination of functions like"
uCalc Echo "Push, Pop, Read, etc...  Something like Read is in turn defined on "
uCalc Echo "line 18, and is a syntax simplification of the more verbose"
uCalc Echo "uc_ReadNum(Forth_Stack, Count)."
uCalc Echo ""
uCalc Echo "Some constructs like BEGIN ... UNTIL, or IF ... THEN do not fit the"
uCalc Echo "mold of other items defined with Def ... --> ... .  So they are"
uCalc Echo "defined in another section using 'uCalc Syntax' directly."
uCalc Echo ""
uCalc Echo "Something important to note is that 'FORTH ' is defined as a special"
uCalc Echo "prefix (line 108), which consumes words from the stack one at a time."
uCalc Echo ""
uCalc Echo "Press F6 for a list of sample Forth code you can play with, then paste"
uCalc Echo "the following to load an interactive session of Forth."
uCalc Echo ""
uCalc Echo '> uCalc Load "Forth.uc"'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

uCalc Prefix \q\q
uCalc(uc_SetDefaultThread, \q\q, OriginalThread)
MainPrompt      = "ucalc> "
MultiLinePrompt = "ucalc>>"
RenameItem("_Print", "Print")

--3e--
Cls
Dim _hWnd As Dword
uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))
KeyExtCode(63) = "uCalc Exit" + Chr(13)
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Logo.uc", "", 0)' + Chr(13)
uCalc Echo "3e. The Logo language"
uCalc Echo ""
uCalc Echo "There is a tiny version of the Logo language, which you can load into"
uCalc Echo "the interpreter from Logo.uc.  This particular implementation is just"
uCalc Echo "a quick hack, and not a particularly complete or correct one."
uCalc Echo "However, it defines enough for you to draw interesting pictures with it."
uCalc Echo ""
uCalc Echo "Press F6 to open Logo.uc see what it looks like.  Then paste the following"
uCalc Echo "code which starts a session of Logo, then defines a function that draws a"
uCalc Echo "square, and another one that uses the square definition to create a function"
uCalc Echo "that draws a flower.  The last line then draws the flower on the screen."
uCalc Echo ""
uCalc Echo '> uCalc Load "Logo.uc"'
uCalc Echo "> to square repeat 4 [forward 50 right 90] end"
uCalc Echo "> to flower repeat 36 [right 10 square] end"
uCalc Echo "> flower"
uCalc Echo ""
uCalc Echo "The following defines a function that draws 4 flowers, then draws them:"
uCalc Echo ""
uCalc Echo "> to flowers repeat 4 [flower forward 70 right 90] end"
uCalc Echo "> flowers"
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Session

uCalc Prefix ''
_hWnd = hWnd
uCalc(uc_SetDefaultThread, '', OriginalThread)
MainPrompt      = 'ucalc> '
MultiLinePrompt = 'ucalc>>'
DestroyWindow(_hWnd)
RenameItem("_Print", "Print")

--3f--
Cls
ucVersion = ""
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Lisp.uc", "", 0)' + Chr(13)
uCalc Echo "3f. The Lisp language"
uCalc Echo ""
uCalc Echo "The process of constructing a uCalc version of Lisp was similar to what"
uCalc Echo "was done with Forth, which was described earlier.  Although for Lisp I"
uCalc Echo "had some prior knowledge of that language, it was possible to construct"
uCalc Echo "Lisp by going through the tutorial found at mypage.iu.edu/~colallen/lp/"
uCalc Echo "Take a moment now to open the Lisp.uc file for inspection by pressing"
uCalc Echo "F6.  This represents just one possible way of constructing Lisp.  Though"
uCalc Echo "this method is good for demonstrating language construction techniques,"
uCalc Echo "it is not necessarily ideal for creating an optimized version of Lisp."
uCalc Echo ""
uCalc Echo "Of note is the redefinition of character patterns.  Unlike programming"
uCalc Echo "languages such as BASIC, in Lisp variable names can include characters"
uCalc Echo "like - (minus symbol), + (plus) etc...  as in 'my-variable'.  So an"
uCalc Echo "alphanumeric pattern is re-defined in line 23 to include additional"
uCalc Echo "symbols.  The single quote character is used in the generic uCalc"
uCalc Echo "interpreter as a literal quote, the same as double quote.  However,"
uCalc Echo "the single quote character has a different special meaning in Lisp."
uCalc Echo "So the single quote is re-defined as a property-less pattern."
uCalc Echo ""
uCalc Echo "The file has two syntax groups; one defines an intermediate language,"
uCalc Echo "which is used in the second syntax group for defining actual Lisp constructs."
uCalc Echo ""
uCalc Echo "Press F5 to continue."
uCalc Session
Cls

uCalc(uc_SetDefaultThread, "", uCalc(uc_NewThread))
KeyExtCode(63) = "uCalc Exit" + Chr(13)
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Test\Lisp.in", "", 0)' + Chr(13)
uCalc Echo "Press F6 to view interactive Lisp code you can play with."
uCalc Echo "Then run a session of Lisp by pasting in the following line:"
uCalc Echo ""
uCalc Echo '> uCalc Load "Lisp.uc"'
uCalc Echo ""
uCalc Echo "Experiment! Then press F5 to continue."
uCalc Echo ""
uCalc Session

uCalc Prefix \q\q
uCalc(uc_SetDefaultThread, \q\q, OriginalThread)
MainPrompt      = "ucalc> "
MultiLinePrompt = "ucalc>>"

Cls
uCalc Echo "Conclusion"
uCalc Echo ""
uCalc Echo "Thank you for going through the uCalc Language Builder interactive"
uCalc Echo "tutorial.  If you would like to review a concept, press F7 to see"
uCalc Echo "the table of contents and instructions on how to jump to a topic."
uCalc Echo ""
uCalc Echo "Hopefully, you now have a general idea of how the language builder"
uCalc Echo "works.  Now it's your turn to try your hand at creating a language."
uCalc Echo ""
uCalc Echo "You might be curious about how the tutorial was built.  If so, press F6"
uCalc Echo "to browse through Tutorial.uc."
uCalc Echo ""
uCalc Echo "Your feedback is very important.  You will find an informal questionnaire"
uCalc Echo "in the file named Questions.Txt.  Use this as a guide for sending"
uCalc Echo "feedback.  Visit www.ucalc.com to submit your feedback."
uCalc Echo ""
uCalc Echo "If you find uCalc Language Builder interesting, be sure to tell others"
uCalc Echo "about it."
uCalc Echo ""

ExitCommand     = "uCalc Exit \qDo you want to quit? (y/n)\q Y"
uCalc Syntax Continue ::= SetInput(ExitCommand)
KeyExtCode(64) = 'ShellExecute(0, "", "CMD.EXE", "/C Notepad Tutorial.uc", "", 0)' + Chr(13)
