// Extended, String, and Stack are already pre-defined in the interpreter.
// Those 3 types can be renamed if necessary, but should not be un-defined.

// --> See Types.Txt for an explanation of this file.

uCalc Prefix "uCalc Define "
   Begin
      DataType: Single
      Size: 4
      TypeHandler: ucAddr(uc_Single)
      ConvertsTo: Extended, ucAddr(uc_Convert_Single_Extended)
   End
   
   Begin
      DataType: Double
      Size: 8
      TypeHandler: ucAddr(uc_Double)
      ConvertsTo: Extended, ucAddr(uc_Convert_Double_Extended)
   End

   Begin
      DataType: Integer
      Size: 2
      TypeHandler: ucAddr(uc_Int16)
      ConvertsTo: Extended, ucAddr(uc_Convert_Int16_Extended)      
   End

   Begin
      DataType: Long
      Size: 4
      TypeHandler: ucAddr(uc_Int32)
      ConvertsTo: Extended, ucAddr(uc_Convert_Int32_Extended)  
      ConvertsFrom: Integer
      ConvertsTo: Integer
   End

   Begin
      DataType: Int64
      Size: 8
      TypeHandler: ucAddr(uc_Int64)
      ConvertsTo: Extended, ucAddr(uc_Convert_Int64_Extended)      
   End

   Begin
      DataType: Byte
      Size: 1
      TypeHandler: ucAddr(uc_Int8u)
      ConvertsTo: Extended
      ConvertsTo: Long
   End

   Begin
      DataType: Word
      Size: 2
      TypeHandler: ucAddr(uc_Int16u)
      ConvertsTo: Extended
      ConvertsTo: Long
      ConvertsFrom: Byte
      ConvertsFrom: Long
   End

   Begin
      DataType: Dword
      Size: 4
      TypeHandler: ucAddr(uc_Int32u)
      ConvertsTo: Long
      ConvertsTo: Extended, ucAddr(uc_Convert_Int32u_Extended)
      ConvertsFrom: Long
   End

   Begin
      DataType: Currency
      Size: 8
      TypeHandler: ucAddr(uc_Currency)
      ConvertsTo: Extended
   End

   Begin
      DataType: LPCSTR
      TypeHandler: ucAddr(uc_String_LPCSTR)
      ConvertsTo: String
   End

   Begin
      DataType: FixedString
      TypeHandler: ucAddr(uc_String_Fixed)
      ConvertsTo: String
   End

   Begin
      DataType: SortedList
      Size: 4
      TypeHandler: ucAddr(uc_Stack)
   End

   Begin
      DataType: Table
      Size: 4
      TypeHandler: ucAddr(uc_Stack)
   End

   Begin
      DataType: String
      Size: 4
      TypeHandler: ucAddr(uc_String)
      ConvertsTo: LPCSTR
      ConvertsTo: FixedString
   End

   Begin
      DataType: Void
      TextData: Ok
      Size: 10
      TypeHandler: ucAddr(uc_Void)
   End

   Begin
      DataType: Extended
      ConvertsTo: Long, ucAddr(uc_Convert_Extended_Int32)
      ConvertsTo: Dword, ucAddr(uc_Convert_Extended_Int32)
      ConvertsTo: Single, ucAddr(uc_Convert_Extended_Single)
      ConvertsTo: Double, ucAddr(uc_Convert_Extended_Double)
      ConvertsTo: Byte
      ConvertsTo: Word
      ConvertsTo: Integer
   End

   Begin
      DataType: SpecialString
      Size: 4
      TypeHandler: ucAddr(uc_String)
      ConvertsFrom: Byte
      ConvertsFrom: Word
      ConvertsFrom: Integer
      ConvertsFrom: Long
      ConvertsFrom: Int64
      ConvertsFrom: Dword
      ConvertsFrom: Single
      ConvertsFrom: Double
      ConvertsFrom: Extended
      ConvertsFrom: Currency
      ConvertsFrom: LPCSTR
      ConvertsFrom: FixedString
      ConvertsFrom: String
      ConvertsFrom: Table
      ConvertsFrom: Stack
      ConvertsFrom: SortedList
   End                
ucalc Prefix ""
