' -----------------------------------------------------------------
' uCalcPB.Bas : PowerBASIC include file for uCalc FMP
' Designed to work with PB/CC and PB/Win.
'
' uCalc FMP 2.91
' Copyright (c) 2000-2007 by Daniel Corbier.  All rights reserved.
' Visit www.ucalc.com for additional resources.
' -----------------------------------------------------------------
' Definition properties
%ucAlphaNumeric   = 1
%ucArgSeparator   = 2
%ucCodeBlock      = 3
%ucCodeBlockMatch = 4
%ucEvalInsert     = 5
%ucExpandInsert   = 6
%ucMemberAccess   = 7
%ucQuotedText     = 8
%ucStatementSep   = 9
%ucWhiteSpace     = 10

%ucFuncDefEnd = 11
%ucCurrentThread = 12

%ucPartialBlockStart = 13
%ucPartialBlockEnd   = 14

%ucFunction       = 16
%ucLiteral        = 32
%ucReducible      = 64
%ucSymbol         = 128
%ucVariable       = 256
%ucInfix          = 512
%ucPrefix         = 1024
%ucPostfix        = 2048
%ucOperator       = 4096
%ucPassOnce       = 8192
%ucLock           = 16384


' uCalc Commands
%uc_Define             = 1
%uc_DefineSyntax       = 2
%uc_EvalDbl            = 4
%uc_EvalExt            = 5
%uc_EvalStr            = 6
%uc_EvaluateDbl        = 7
%uc_EvaluateExt        = 8
%uc_Evaluate           = 8
%uc_EvaluateLng        = 9
%uc_EvaluateStr        = 10
%uc_GetCaseSensitivity = 11
%uc_GetCodeAddr        = 12
%uc_GetDefaultPrecedence = 13
%uc_GetDefaultRank     = 14
%uc_GetDefaultType     = 15
%uc_GetDefaultThread   = 16
%uc_GetDefSeparator    = 17
%uc_GetErrorNumber     = 18
%uc_GetParentThread    = 19
%uc_GetSyntaxEqual     = 20
%uc_Parse              = 21
%uc_ReleaseItem        = 22
%uc_SetCaseSensitivity = 23
%uc_SetCodeAddr        = 24
%uc_SetDefaultPrecedence = 25
%uc_SetDefaultRank     = 26
%uc_SetDefaultThread   = 27
%uc_SetDefaultType     = 28
%uc_SetDefSeparator    = 29
%uc_SetErrorNumber     = 30
%uc_SetParentThread    = 31
%uc_SetSyntaxEqual     = 32
%uc_NewThread          = 33
%uc_PartialBlockCount  = 34

%uc_RegExWordBoundaryChars = 35
%uc_RegExEscapeChar = 36
%uc_License = 37
%uc_License_Error = 0
%uc_License_Demo = 1
%uc_License_Free = 2
%uc_License_Commercial_FMP = 3
%uc_License_LanguageBuilder = 4
%uc_License_Beta = 5

%uc_ReDefine = 38
%uc_AddErrorHandler = 40
%uc_GetSymbolTable = 41

%uc_GetCallbackData = 50
%uc_SetCallbackReturn = 51

%uc_GetExpression = 60
%uc_GetExpressionType = 61
%uc_GetSymbol = 62
%uc_GetItem = 63
%uc_GetLocation = 64

%uc_GetPatternType = 65
%uc_GetPatternProperties = 66

%uc_ItemClone = 70
%uc_DataConvert = 71
%uc_DataCopy = 72
%uc_DataAlloc = 72
%uc_DataFree = 73
%uc_DataReset = 74

%uc_SetFPU = 75
%uc_SetFPU_HostProg = 76
%uc_GetFPU = 77
%uc_GetFPU_HostProg = 78
%uc_ToggleFPU = 79
%uc_ToggleFPU_HostProg = 80
%uc_ErrorClear = 85

%uc_SetErrorMessage = 91
%uc_GetErrorMessage = 92

%uc_SerialNumber = 93
%uc_SetTurbo = 94
%uc_Expand = 95
%uc_GetNextItem = 96
%uc_GetItemData = 97
%uc_SetItemData = 98

%uc_Properties = 1
%uc_Thread = 2
%uc_Address = 3
%uc_SymbolName = 4
%uc_Rank = 5
%uc_Precedence = 6
%uc_OverloadHandle = 7
%uc_OverloadCount = 8
%uc_ByteSize = 9
%uc_ArgCount = 10
%uc_DataType = 12
%uc_Handle = 13
%uc_Value = 14
%uc_Property = 15


' Error numbers
%uc_Err_None                    = 0
%uc_Err_Syntax_Error            = 2
%uc_Err_Undefined_Identifier    = 3
%uc_Err_Unknown_Error           = 4
%uc_Err_Unrecognized_Pattern    = 5
%uc_Err_Unrecognized_Command    = 6
%uc_Err_Datatype_Mismatch       = 7
%uc_Err_Invalid_Argument_Count  = 8
%uc_Err_Invalid_Definition      = 9
%uc_Err_CodeBlock_Error         = 10
%uc_Err_Undefined_Callback      = 11
%uc_Err_ErrMsgAlreadyDefined    = 12
%uc_Err_ItemCannotBeModified    = 13
%uc_Err_Unrecognized_Member     = 14

%uc_Err_Array_Bounds_Exceeded   = 20
%uc_Err_Float_Denormal_Operand  = 21
%uc_Err_Float_Divide_By_Zero    = 22
%uc_Err_Float_Inexact_Result    = 23
%uc_Err_Float_Invalid_Operation = 24
%uc_Err_Float_Overflow          = 25
%uc_Err_Float_Stack_Check       = 26
%uc_Err_Float_Underflow         = 27
%uc_Err_Integer_Divide_By_Zero  = 28
%uc_Err_Integer_Overflow        = 29
%uc_Err_Privileged_Instruction  = 30

' FPU Control Word Settings
%uc_FPU_Mask_InvalidOp     = 1
%uc_FPU_Mask_DenormalOp    = 2
%uc_FPU_Mask_ZeroDivide    = 4
%uc_FPU_Mask_Overflow      = 8
%uc_FPU_Mask_Underflow     = 16
%uc_FPU_Mask_PrecisionLoss = 32

%uc_FPU_Precision_Single   = 0
%uc_FPU_Precision_Double   = 256
%uc_FPU_Precision_Extended = 768

%uc_FPU_Round_Even         = 0
%uc_FPU_Round_Down         = 1024
%uc_FPU_Round_Up           = 2048
%uc_FPU_Round_Toward       = 3072


%ucAbort = 0
%ucResume = 1

' Data type handler callback action modes
%uc_TypeHandler_Store = 2
%uc_TypeHandler_StringOutput = 3
%uc_TypeHandler_Free = 4
%uc_TypeHandler_FuncRet = 5
%uc_TypeHandler_Copy = 6
%uc_TypeHandler_Alloc = 7
%uc_TypeHandler_Reset = 8

%uc_Callback_Undefined = 0
' Returns error

' Data Type callbacks
%uc_Complex     = 1
%uc_Currency    = 2
%uc_Double      = 3
%uc_Extended    = 4
%uc_Int8        = 5
%uc_Int8u       = 6
%uc_Int16       = 7
%uc_Int16u      = 8
%uc_Int32       = 9
%uc_Int32u      = 10
%uc_Int64       = 11
%uc_Int64u      = 12
%uc_Single      = 13
%uc_String      = 14
%uc_String_LPCSTR= 15
%uc_String_Fixed= 16
%uc_String_Wide = 17
%uc_Stack       = 18
%uc_Void        = 19
%uc_User_Type   = 20

%uc_SetVariableValue = 21

%uc_Convert_Generic = 23
%uc_Convert_Double_Extended = 24
%uc_Convert_Int8_Extended = 25
%uc_Convert_Int8u_Extended = 26
%uc_Convert_Int16_Extended = 27
%uc_Convert_Int16u_Extended = 28
%uc_Convert_Int32_Extended = 29
%uc_Convert_Int32u_Extended = 30
%uc_Convert_Int64_Extended = 31
%uc_Convert_Int64u_Extended = 32
%uc_Convert_Single_Extended = 33
%uc_Convert_Extended_Double = 37
%uc_Convert_Extended_Single = 38
%uc_Convert_Extended_Int16u = 39
%uc_Convert_Extended_Int32 = 40
%uc_Convert_Complex_Extended = 41
%uc_Convert_Extended_Complex = 42

' Default built-in routines.

%uc_Op_Negate_Extended = 43
%uc_Op_UnaryPlus_Extended = 44
%uc_Op_Percentage_Extended = 45
%uc_Op_StrConcat = 46
%uc_Op_Add_Int32 = 47
%uc_Op_Add_Extended = 48
%uc_Op_Add_Complex = 49
%uc_Op_Subtract_Int32 = 50
%uc_Op_Subtract_Extended = 51
%uc_Op_Multiply_Int32 = 52
%uc_Op_Multiply_Extended = 53
%uc_Op_Multiply_Complex = 54
%uc_Op_Divide_Int32 = 55
%uc_Op_Divide_Extended = 56
%uc_Op_Mod_Int32 = 57
%uc_Op_Mod_Extended = 58
%uc_Op_PowerOf_ExtToExt = 59
%uc_Op_PowerOf_ExtToLng = 60
%uc_Op_PowerOf_CplxToCplx = 61

%uc_Op_GreaterThan_Extended = 62
%uc_Op_GreaterOrEqual_Extended = 63
%uc_Op_LessThan_Extended = 64
%uc_Op_LessOrEqual_Extended = 65
%uc_Op_Equal_Extended = 66
%uc_Op_NotEqual_Extended = 67

%uc_Op_GreaterThan_Str = 68
%uc_Op_GreaterOrEqual_Str = 69
%uc_Op_LessThan_Str = 70
%uc_Op_LessOrEqual_Str = 71
%uc_Op_Equal_Str = 72
%uc_Op_NotEqual_Str = 73

%uc_Op_Not_Int32 = 74
%uc_Op_And_Int32 = 75
%uc_Op_Or_Int32 = 76
%uc_Op_Xor_Int32 = 77
%uc_Op_Eqv_Int32 = 78
%uc_Op_Imp_Int32 = 79

%uc_Op_AndAlso = 80
%uc_Op_OrElse = 81

%uc_Op_Factorial = 82

%uc_Func_IIf = 83
%uc_Func_IIf_Str = 84

%uc_Func_Sin = 85
%uc_Func_Cos = 86
%uc_Func_Tan = 87
%uc_Func_Atan = 88
%uc_Func_Ceil = 89
%uc_Func_Abs_Extended = 90
%uc_Func_Abs_Int32 = 91
%uc_Func_Exp = 92
%uc_Func_Log = 93
%uc_Func_Floor = 94
%uc_Func_SquareRoot = 95
%uc_Func_BaseConvert = 96

%uc_Func_ExprHandle = 97
%uc_Func_VarPtr = 98
%uc_Func_uCalc = 99
%uc_Func_uCalcStr = 100
%uc_Func_ucAddr = 101
%uc_Func_ValueAtAddr = 102

%uc_Func_Asc = 103
%uc_Func_Chr = 104

%uc_Func_For  = 105
%uc_Func_Loop = 107

%uc_Func_LoadLibrary = 108
%uc_Func_GetProcAddress = 109

%uc_NullString = 110
%uc_True = 111

%uc_Func_Peek = 112
%uc_Func_Poke = 113

%uc_Func_Int = 115
%uc_Func_Frac = 116
%uc_Func_Sgn = 117

%uc_Func_PushData_Stack = 120
' %uc_Func_PopHandle_Stack = 121
%uc_Func_PopNum_Stack = 122
%uc_Func_PopStr_Stack = 123
%uc_Func_ReadHandle_Stack = 124
%uc_Func_ReadNum_Stack = 125
%uc_Func_ReadStr_Stack = 126
%uc_Func_Count_Stack = 127
%uc_Op_Concat_Stack = 128
%uc_Func_Populate_Stack = 129

%uc_Insert_Table = 130
%uc_Delete_Table = 131
%uc_Index_Table  = 132
%uc_Handle_Table = 133

%uc_Func_StackFormat = 135

' Misc other callbacks
%uc_EvaluateAddr = 150
%uc_EvaluateTurboAddr = 151
%uc_ExceptionHelper = 152
%uc_DefaultErrorHandler = 153

' Interpreter addresses
%uc_Interp_DefHandle     = 160 ' DWord Ptr
%uc_Interp_ExitCommand   = 161 ' String Ptr
%uc_Interp_LastResultNum = 163 ' Extended Ptr
%uc_Interp_LastResultStr = 164 ' String Ptr
%uc_Interp_LineContinue  = 165
%uc_Interp_MainPrompt    = 166
%uc_Interp_MultiLinePrompt = 167
%uc_Interp_Prefix = 168
%uc_Interp_Postfix = 169
%uc_Interp_Tab = 170
%uc_Interp_Insert = 171
%uc_Interp_InputBuffer = 172 ' +++ Add these to other includes and help file
%uc_Interp_OutputBuffer = 173
%uc_Interp_KeyCode = 174
%uc_Interp_KeyExtCode = 175

%uc_Op_Ext_Plus_Complex = 190
%uc_Op_Ext_Times_Complex = 191

%uc_Func_If_ElseIf = 195
%uc_Func_SetSyntaxParams = 196
%uc_Func_SpecialUCase = 197
%uc_Func_Rand = 198

%ucTrue  = 1
%ucFalse = 0

%uc_First = 1
%uc_Last  = -1
' End Of Constants


Global ucIsInitialized As Long
Global ucExtended, ucString, ucLPCSTR, ucFixedString, ucDouble As Dword
Global ucLong, ucDword, ucComplex, ucByte, ucTable, ucVoid, ucStack As Dword
Global ucSortedList As Dword
Global ucDefaultErrorHandler As Dword

#If Not %Def(%ucMake)

   #If Not %Def(%ucDebug)
      Declare Function ucEvaluateExt Lib "uCalcF29.dll" Alias "ucEvaluateExt" (ByVal Item As Dword) As Extended
      Declare Function ucStrReturn Lib "uCalcF29.dll" Alias "ucStrReturn" (ByVal TextPtr As Dword) As String
      Declare Function uCalc_ Lib "uCalcF29.dll" Alias "uCalc" (ByVal ucCommand As Long, _
      ByVal TextArg As Dword, ByVal MiscArg1 As Dword, ByVal MiscArg2 As Dword, _
      ByVal ReturnPtr As Dword, ByVal t As Dword) As Dword
   #EndIf

Function uCalc(ByVal ucCommand As Long, Optional ByVal TextArg As Dword, _
               ByVal MiscArg1 As Dword, ByVal MiscArg2 As Dword, _
               ByVal ReturnPtr As Dword, ByVal t As Dword) As Dword

   If ucIsInitialized = %ucFalse Then Call ucInitialize()
   Function = uCalc_(ucCommand, TextArg, MiscArg1, MiscArg2, ReturnPtr, t)
End Function

Function uCalcStr(ByVal ucCommand As Long, Optional ByVal TextArg As Dword, _
               ByVal MiscArg1 As Dword, ByVal MiscArg2 As Dword, _
               ByVal ReturnPtr As Dword, ByVal t As Dword) As String

   If ucIsInitialized = %ucFalse Then Call ucInitialize()
   Function = ucStrReturn(uCalc_(ucCommand, TextArg, MiscArg1, MiscArg2, ReturnPtr, t))
End Function

Function ucAddr(ByVal AddressIndex As Long) As Dword
   Function = uCalc(%uc_GetCodeAddr, 0, AddressIndex)
End Function

Function ucDefine(Definition As String, Optional ByVal Arg1 As Dword, ByVal Arg2 As Dword, _
                  ByVal Arg3 As Dword, ByVal t As Dword) As Dword
   Function = uCalc(%uc_Define, StrPtr(Definition), Arg1, Arg2, Arg3, t)
End Function

Function ucDefineConstant(Definition As String, Optional ByVal t As Dword) As Dword
   Dim ItemDef$
   ItemDef$ = "Var: " + Definition
   Function = uCalc(%uc_Define, StrPtr(ItemDef$), %ucLock, 0, 0, t)
End Function

Function ucDefineFunction(Definition As String, Optional ByVal ItemAddress As Dword, ByVal t As Dword) As Dword
   Dim ItemDef$
   ItemDef$ = "Func: " + Definition
   If ItemAddress Then ItemDef$ = ItemDef$ + " At " + Str$(ItemAddress)
   Function = uCalc(%uc_Define, StrPtr(ItemDef$), 0, 0, 0, t)
End Function

Function ucDefineOperator(Definition As String, Optional ByVal ItemAddress As Dword, ByVal t As Dword) As Dword
   Dim ItemDef$
   ItemDef$ = "Op: " + Definition
   If ItemAddress Then ItemDef$ = ItemDef$ + " At " + Str$(ItemAddress)
   Function = uCalc(%uc_Define, StrPtr(ItemDef$), 0, 0, 0, t)
End Function

Function ucDefineSyntax(Definition As String, Optional ByVal Rank As Dword, ByVal t As Dword) As Dword
   If Rank = 0 Then Rank = 1
   Function = uCalc(%uc_DefineSyntax, StrPtr(Definition), Rank, 0, 0, t)
End Function

Function ucDefineVariable(Definition As String, Optional ByVal ItemAddress As Dword, ByVal t As Dword) As Dword
   Dim ItemDef$
   ItemDef$ = "Var: " + Definition
   If ItemAddress Then ItemDef$ = ItemDef$ + " At " + Str$(ItemAddress)
   Function = uCalc(%uc_Define, StrPtr(ItemDef$), 0, 0, 0, t)
End Function

Function ucEval(Expr As String, Optional ByVal t As Dword) As Extended
   Dim Answer As Extended

   uCalc(%uc_EvalExt, StrPtr(Expr), 0, 0, VarPtr(Answer), t)
   Function = Answer
End Function

Function ucEvalStr(Expr As String, Optional ByVal ExprType As Dword, ByVal t As Dword) As String
   Function = uCalcStr(%uc_EvalStr, StrPtr(Expr), ExprType, 0, 0, t)
End Function

Macro ucEvaluate(Expr) = ucEvaluateExt(Expr)

Function ucEvaluateStr(ByVal Item As Dword) As String
   Function = uCalcStr(%uc_EvaluateStr, 0, Item)
End Function

Function ucExpand(Expr As String, Optional ByVal t As Dword) As String
   Function = uCalcStr(%uc_Expand, StrPtr(Expr), 0, 0, 0, t)
End Function

Function ucErrorMessage(Optional ByVal ErrNum As Dword, ByVal t As Dword) As String
   Function = uCalcStr(%uc_GetErrorMessage, 0, ErrNum, 0, 0, t)
End Function
Function ucGetError(Optional ByVal t As Dword) As Long
   Function = uCalc(%uc_GetErrorNumber, 0, 0, 0, 0, t)
End Function
Function ucError(Optional ByVal t As Dword) As Long
   Function = uCalc(%uc_GetErrorNumber, 0, 0, 0, 0, t)
End Function
Function ucSetError(ByVal ErrorNum As Long, Optional ByVal t As Dword) As Long
   Function = uCalc(%uc_SetErrorNumber, 0, ErrorNum, 0, 0, t)
End Function

Function ucGetExpr(Optional t As Dword) As String
   Function = uCalcStr(%uc_GetExpression, 0, 0, 0, 0, t)
End Function

Function ucGetItemHandle(SymbolName As String, Optional ByVal ucProperties As Dword, ByVal t As Dword) As Dword
   Function = uCalc(%uc_GetItemData, StrPtr(SymbolName), 0, %uc_Handle, ucProperties, t)
End Function

Function ucGetNextItem(Expr As String, ByRef i As Long, Optional ByVal t As Dword) As String
   Function = uCalcStr(%uc_GetNextItem, StrPtr(Expr), 0, 0, VarPtr(i), t)
End Function

Function ucGetSymbol(Optional t As Dword) As String
   Function = uCalcStr(%uc_GetSymbol, 0, 0, 0, 0, t)
End Function

Function ucInterpret(Expr As String, Optional ByVal ExprType As Dword, ByVal t As Dword) As String
   Function = uCalcStr(%uc_EvalStr, StrPtr(Expr), ExprType, 1, 0, t)
End Function

Function ucLicense(ByVal LicenseOption As Long, Optional ByVal L1 As Dword, ByVal L2 As Dword, ByVal L3 As Dword) As Long
   Function = uCalc(%uc_License, L1, LicenseOption, L2, L3)
End Function

Function ucNewThread(Optional ByVal ParentThread As Dword) As Dword
   Function = uCalc(%uc_NewThread, 0, ParentThread)
End Function

Function ucParamCount(ByVal Expr As Dword) As Long
   ucParamCount = uCalc(%uc_GetCallbackData, 0, Expr)
End Function

Function ucParamDbl(ByVal Expr As Dword, ByVal Index As Long) As Double
   Dim ReturnValue As Double

   uCalc(%uc_GetCallbackData, 0, Expr, Index, VarPtr(ReturnValue), ucDouble)
   ucParamDbl = ReturnValue
End Function

Function ucParamStr(ByVal Expr As Dword, ByVal Index As Long) As String
   ucParamStr = uCalcStr(%uc_GetCallbackData, 0, Expr, Index)
End Function

Function ucParse(Expr As String, Optional ByVal ExprType As Dword, ByVal t As Dword) As Dword
   Function = uCalc(%uc_Parse, StrPtr(Expr), ExprType, 0, 0, t)
End Function

Function ucReleaseItem(ByVal ucItem As Dword) As Long
   Function = uCalc(%uc_ReleaseItem, 0, ucItem)
End Function

Sub ucReturnDbl(ByVal Expr As Dword, ByVal ReturnValue As Double)
   uCalc(%uc_SetCallbackReturn, 0, Expr, 0, VarPtr(ReturnValue), ucDouble)
End Sub

Sub ucReturnStr(ByVal Expr As Dword, ByRef ReturnValue As String)
   uCalc(%uc_SetCallbackReturn, StrPtr(ReturnValue), Expr)
End Sub

Function ucSetErrMsg(ByVal ErrIndex As Long, ErrMessage As String, Optional ByVal t As Dword) As Long
   Function = uCalc(%uc_SetErrorMessage, StrPtr(ErrMessage), ErrIndex, 0, 0, t)
End Function

Function ucSetErrorNumber(ByVal ErrorNumber As Long, Optional ByVal t As Dword) As Long
   Function = uCalc(%uc_SetErrorNumber, 0, ErrorNumber, 0, 0, t)
End Function

#If Not %Def(%ucInterpreter)
Sub ucInitialize()
   ucIsInitialized = %ucTrue

   ucLicense(%uc_License_Demo)
   ucDefaultErrorHandler = uCalc(%uc_AddErrorHandler, 0, ucAddr(%uc_DefaultErrorHandler))

   ucSetErrMsg %uc_Err_None,                    "No error"
   ucSetErrMsg %uc_Err_Syntax_Error,            "Syntax error"
   ucSetErrMsg %uc_Err_Undefined_Identifier,    "Undefined identifier"
   ucSetErrMsg %uc_Err_Unknown_Error,           "Unknown error"
   ucSetErrMsg %uc_Err_Unrecognized_Pattern,    "Unrecognized pattern"
   ucSetErrMsg %uc_Err_Unrecognized_Command,    "Unrecognized command"
   ucSetErrMsg %uc_Err_Datatype_Mismatch,       "Data type mismatch"
   ucSetErrMsg %uc_Err_CodeBlock_Error,         "Code block delimiter error"
   ucSetErrMsg %uc_Err_Invalid_Argument_Count,  "Invalid number of arguments"
   ucSetErrMsg %uc_Err_Invalid_Definition,      "Invalid definition"
   ucSetErrMsg %uc_Err_Undefined_Callback,      "Undefined callback"
   ucSetErrMsg %uc_Err_ErrMsgAlreadyDefined,    "Error message already defined"
   ucSetErrMsg %uc_Err_ItemCannotBeModified,    "This item cannot be modified"
   ucSetErrMsg %uc_Err_Unrecognized_Member,     "Unrecognized member"
   ucSetErrMsg %uc_Err_Array_Bounds_Exceeded,   "Array bounds exceeded"
   ucSetErrMsg %uc_Err_Float_Denormal_Operand,  "Denormal operand"
   ucSetErrMsg %uc_Err_Float_Divide_By_Zero,    "Division by 0"
   ucSetErrMsg %uc_Err_Float_Inexact_Result,    "Inexact result"
   ucSetErrMsg %uc_Err_Float_Invalid_Operation, "Invalid operation"
   ucSetErrMsg %uc_Err_Float_Overflow,          "Floating point overflow"
   ucSetErrMsg %uc_Err_Float_Stack_Check,       "Floating point stack Error"
   ucSetErrMsg %uc_Err_Float_Underflow,         "Floating point underflow"
   ucSetErrMsg %uc_Err_Integer_Divide_By_Zero,  "Integer division by 0"
   ucSetErrMsg %uc_Err_Integer_Overflow,        "Integer overflow"
   ucSetErrMsg %uc_Err_Privileged_Instruction,  "Privileged instruction denied"

   ucExtended = ucDefine("DataType: Extended ~~ Size: 10 ~~ TypeHandler: #", ucAddr(%uc_Extended))
   ucDouble   = ucDefine("DataType: Double   ~~ Size: 8  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Double), ucAddr(%uc_Convert_Double_Extended))
   ucLong     = ucDefine("DataType: Long     ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int32),  ucAddr(%uc_Convert_Int32_Extended))
   ucDword    = ucDefine("DataType: Dword    ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int32u), ucAddr(%uc_Convert_Int32u_Extended))
   ucString   = ucDefine("DataType: String   ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: LPCSTR", ucAddr(%uc_String))
   ucFixedString = ucDefine("DataType: FixedString ~~ TypeHandler: # ~~ ConvertsTo: String ~~ ConvertsFrom: String", ucAddr(%uc_String_Fixed))
   ucByte     = ucDefine("DataType: Byte     ~~ Size: 1  ~~ TypeHandler: # ~~ ConvertsTo: Extended", ucAddr(%uc_Int8u))
   ucLPCSTR   = ucDefine("DataType: LPCSTR               ~~ TypeHandler: # ~~ ConvertsTo: String", ucAddr(%uc_String_LPCSTR))
   ucStack    = ucDefine("DataType: Stack    ~~ Size: 4  ~~ TypeHandler: #", ucAddr(%uc_Stack))
   ucSortedList = ucDefine("DataType: SortedList ~~ Size: 4  ~~ TypeHandler: #", ucAddr(%uc_Stack))
   ucTable    = ucDefine("DataType: Table    ~~ Size: 4      ~~ TypeHandler: #", ucAddr(%uc_Stack))
   ucVoid     = ucDefine("DataType: Void     ~~ Size: 10 ~~ TextData: Ok ~~ TypeHandler: #", ucAddr(%uc_Void))


   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Long, #", ucAddr(%uc_Convert_Extended_Int32))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Dword, #", ucAddr(%uc_Convert_Extended_Int32))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Double, #", ucAddr(%uc_Convert_Extended_Double))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Byte")

   ucDword = ucDefine("DataType: Dword ~~ ConvertsTo: Long")
   ucDefine("DataType: Double ~~ ConvertsTo: Long")

   ucDefine("Pattern:[\x00\x01\x02]") ' Reserved characters
   ucDefine("Pattern:\x03 ~~ \x03 ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Pattern:\x05") ' Define Codeblock bootstrap
   ucDefine("Pattern:\x06 ~~ \x07", %ucCodeBlock)
   ucDefine("Pattern: :")
   ucDefine("Pattern: :=")
   ucDefine("Pattern:\[ ~~ \]", %ucCodeBlock)
   ucDefine("Pattern:\{ ~~ \} ~~ DataType: #2 ~~ Address: #3", %ucCodeBlock, ucStack, ucAddr(%uc_Func_Populate_Stack))
   ucDefine("Pattern:[\q] ~~ [\q] ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Pattern:['] ~~ ['] ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Pattern:\x0D\x0A", %ucStatementSep) ' Carriage Return
   ucDefine("Pattern:;", %ucStatementSep)
   ucDefine("Pattern:~Eval", %ucEvalInsert)
   ucDefine("Pattern:~Expand", %ucExpandInsert)
   ucDefine("Pattern:\.", %ucMemberAccess)
   ucDefine("Pattern:\~\~")
   ucDefine("Pattern:,", %ucArgSeparator)
   ucDefine("Pattern:\( ~~ \)", %ucCodeBlock)
   ucDefine("Pattern:[ ]+", %ucWhiteSpace)
   ucDefine("Pattern:[\|+/*^$&#\-=%@!`\\<>?]+", %ucReducible)  ' For operators
   ucDefine("Pattern:([0-9]+\.)?[0-9]*(e[-+]?[0-9]+)? ~~ DataType: #2", %ucLiteral, ucExtended) ' Numeric
   ucDefine("Pattern:[a-z_][0-9a-z_]* ~~ Name: AlphaNum", %ucAlphaNumeric)

   ucDefineSyntax "Op: {Name} '{' {Operand} '}' [As {type}] ::=" _ ' Prefix Operator
                 +"Param: {Operand} ~~ Name: {Name} ~~ DataType: {type} ~~ Properties: " + Str$(%ucPrefix+%ucOperator)
   ucDefineSyntax "Op: '{' {Operand} '}' {Name} [As {type}] ::=" _ ' Postfix Operator
                 +"Param: {Operand} ~~ Name: {Name} ~~ DataType: {type} ~~ Properties: " + Str$(%ucPostfix+%ucOperator)
   ucDefineSyntax "Op: '{' {LeftOp} '}' {Name} '{' {RightOp} '}' [As {type}] ::=" _ ' Infix Operator
                 +"Param: {LeftOp} ~~ Param: {RightOp} ~~ Name: {Name} ~~ DataType: {type} ~~ Properties: " + Str$(%ucInfix+%ucOperator)

   ucDefineSyntax "Op: {Def} { At {addr} | ':=' {Expr:'.+'} } ::= Op: {Def} {addr: ~~ Address: {addr} ~~ StdCall} {Expr: ~~ FuncBody: {Expr}}"
   ucDefineSyntax "Op: {pValue:' *[0-9]+ '} {Def} ::= Precedence: {pValue} ~~ Op: {Def}"
   ucDefineSyntax "Op: Precedence({op}) ::= Op: ~Eval(Precedence({op}))"
   ucDefineSyntax "Op:: {Def:'.+'} ::= NativeCall ~~ Address: # ~~ Op: {Def}"

   ucDefineSyntax "Var: {VarName:'[ ]*[a-z_][0-9a-z_]*'} [As {Type}] [{ = {Value} | At {Addr:' .+'} }] ::=" _
                  +"Variable ~~ Name: {VarName}" _
                  +"{Type: ~~ DataType: {Type}}" _
                  +"{Value: ~~ Value: {Value}}" _
                  +"{Addr: ~~ Address: {Addr}}"
   ucDefineSyntax "Var: {VarName:'[ ]*[a-z_][0-9a-z_]*'} As AnyType ::= AnyType ~~ Var: {VarName}"
   ucDefineSyntax "Var: {PassBy:'( +ByRef)|( +ByVal)|( +ByHandle)|( +ByExpr)'} ::= {PassBy} ~~ Var:"
   ucDefineSyntax "Var: {Def} ... ::= Var: {Def} ~~ VariableArgList"
   ucDefineSyntax "Var: ... ::= Var: _ ~~ VariableArgList"
   ucDefineSyntax "Var: {name:' *[_a-z]*'} = {quote:' *[\x22\x27]'} ::= Var: {name} As String = {quote}"
   ucDefineSyntax "Const: {Def:'.*'} ::= Var: {Def} ~~ Properties: " + Str$(%ucLock)


   ucDefineSyntax "Func: {FuncName} ([{ParamList}]) [As {type:' +[a-z]+[a-z0-9]*'}] [{ At {addr} | = {Def:'.+'} }] ::= " _
                  +"Params: ({ParamList}) ~~ Name: {FuncName} ~~ DataType: {type}" _
                  +"~~ Properties: " + Str$(%ucFunction + %ucPrefix) _
                  +"{addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}"

   ucDefineSyntax "Func:: {Def:'.+'} ::= NativeCall ~~ Address: # ~~ Func: {Def}"


   ucDefineSyntax "Params: ([{SingleParam}]) ::= IsParam ~~ { {SingleParam: Var: {SingleParam}} }"
   ucDefineSyntax "Params: ({Variable} = {Default}) ::= Params: ({Variable} ~~ TextData: {Default})"
   ucDefineSyntax "Params: ({Param1}, {OtherParams}) ::= Params: ({Param1}) ~~ Params: ({OtherParams})"
   ucDefineSyntax "Param: {ParamDef} ~~ ::= IsParam ~~ { Var: {ParamDef} } ~~"

   ucDefine("Op:: -{x}    ~~ Precedence: 25", ucAddr(%uc_Op_Negate_Extended))
   ucDefine("Op:: {x As String}+{y As String} As String ~~ Precedence: 10", ucAddr(%uc_Op_StrConcat))
   ucDefine("Op:: {x As Long}+{y As Long} As Long ~~ Precedence: 10", ucAddr(%uc_Op_Add_Int32))

   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Complex, #", ucAddr(%uc_Convert_Extended_Complex))
   ucComplex  = ucDefine("DataType: Complex ~~ {Var: Real As Extended} ~~ {Var: Imag As Extended = 1} ~~ TypeHandler: #", ucAddr(%uc_Complex))
   ucDefine("Pattern:#i ~~ DataType: #2", %ucLiteral, ucComplex)
   ucDefine("Op:: {x As Complex}+{y As Complex} As Complex ~~ Precedence: 10", ucAddr(%uc_Op_Add_Complex))
   ucDefine("Op:: {x As Complex}*{y As Complex} As Complex ~~ Precedence: 10", ucAddr(%uc_Op_Multiply_Complex))

   ucDefine("Op:: {x}>{y}  As Long ~~ Precedence: 5", ucAddr(%uc_Op_GreaterThan_Extended))
   ucDefine("Op:: {x}<{y}  As Long ~~ Precedence: 5", ucAddr(%uc_Op_LessThan_Extended))
   ucDefine("Op:: {x}>={y} As Long ~~ Precedence: 5", ucAddr(%uc_Op_GreaterOrEqual_Extended))
   ucDefine("Op:: {x}<={y} As Long ~~ Precedence: 5", ucAddr(%uc_Op_LessOrEqual_Extended))
   ucDefine("Op:: {x}<>{y} As Long ~~ Precedence: 5", ucAddr(%uc_Op_NotEqual_Extended))
   ucDefine("Op:: {x}=={y} As Long ~~ Precedence: 5", ucAddr(%uc_Op_Equal_Extended))

   ucDefine("Op:: {x As String}>{y As String}  As Long ~~ Precedence: 5", ucAddr(%uc_Op_GreaterThan_Str))
   ucDefine("Op:: {x As String}<{y As String}  As Long ~~ Precedence: 5", ucAddr(%uc_Op_LessThan_Str))
   ucDefine("Op:: {x As String}>={y As String} As Long ~~ Precedence: 5", ucAddr(%uc_Op_GreaterOrEqual_Str))
   ucDefine("Op:: {x As String}<={y As String} As Long ~~ Precedence: 5", ucAddr(%uc_Op_LessOrEqual_Str))
   ucDefine("Op:: {x As String}<>{y As String} As Long ~~ Precedence: 5", ucAddr(%uc_Op_NotEqual_Str))
   ucDefine("Op:: {x As String}=={y As String} As Long ~~ Precedence: 5", ucAddr(%uc_Op_Equal_Str))

   ucDefine("Op:: {x As Long} And     {y As Long}        As Long ~~ Precedence: 4", ucAddr(%uc_Op_And_Int32))
   ucDefine("Op:: {x As Long} AndAlso {ByExpr y As Long} As Long ~~ Precedence: 4", ucAddr(%uc_Op_AndAlso))
   ucDefine("Op:: {x As Long} Or      {y As Long}        As Long ~~ Precedence: 3", ucAddr(%uc_Op_Or_Int32))
   ucDefine("Op:: {x As Long} OrElse  {ByExpr y As Long} As Long ~~ Precedence: 3", ucAddr(%uc_Op_OrElse))

   ucDefine("Op:: {x}+{y} ~~ Precedence: 10", ucAddr(%uc_Op_Add_Extended))
   ucDefine("Op:: {x}-{y} ~~ Precedence: 10", ucAddr(%uc_Op_Subtract_Extended))
   ucDefine("Op:: {x}*{y} ~~ Precedence: 20", ucAddr(%uc_Op_Multiply_Extended))
   ucDefine("Op:: {x}/{y} ~~ Precedence: 20", ucAddr(%uc_Op_Divide_Extended))
   ucDefine("Op:: {x} Mod {y} ~~ Precedence: 20", ucAddr(%uc_Op_Mod_Extended))
   ucDefine("Op:: {x}^{y} ~~ Precedence: 30", ucAddr(%uc_Op_PowerOf_ExtToExt))
   ucDefine("Op:: {x}^{y As Long} ~~ Precedence: 30", ucAddr(%uc_Op_PowerOf_ExtToLng))

   ucDefine("Op:: {x As Long}!  ~~ Precedence: 40", ucAddr(%uc_Op_Factorial))
   ucDefine("Op:: {x As Long}\{y As Long} As Long ~~ Precedence: 20", ucAddr(%uc_Op_Divide_Int32))

   ucDefine("Func:: Sin(x)", ucAddr(%uc_Func_Sin))
   ucDefine("Func:: Cos(x)", ucAddr(%uc_Func_Cos))
   ucDefine("Func:: Tan(x)", ucAddr(%uc_Func_Tan))
   ucDefine("Func:: Atan(x)", ucAddr(%uc_Func_Atan))
   ucDefine("Func:: Abs(x)", ucAddr(%uc_Func_Abs_Extended))
   ucDefine("Func:: Exp(x)", ucAddr(%uc_Func_Exp))
   ucDefine("Func:: Log(x)", ucAddr(%uc_Func_Log))
   ucDefine("Func:: Ceil(x) As Long", ucAddr(%uc_Func_Ceil))
   ucDefine("Func:: Sqr(x)", ucAddr(%uc_Func_SquareRoot))
   ucDefine("Func:: Int(x)", ucAddr(%uc_Func_Int))
   ucDefine("Func:: Frac(x)", ucAddr(%uc_Func_Frac))
   ucDefine("Func:: Sgn(x)", ucAddr(%uc_Func_Sgn))
   ucDefine("Func:: Rand(x = 1)", ucAddr(%uc_Func_Rand))
   ucDefine("Func:: Rand(x As Long, y As Long)", ucAddr(%uc_Func_Rand))

   ucDefine("Syntax: Max({x}, {y}) ::= IIf({x} > {y}, {x}, {y})")
   ucDefine("Syntax: Max({x}, {y}, {etc}) ::= Max({x}, Max({y}, {etc}))")
   ucDefine("Syntax: Min({x}, {y}) ::= IIf({x} < {y}, {x}, {y})")
   ucDefine("Syntax: Min({x}, {y}, {etc}) ::= Min({x}, Min({y}, {etc}))")

   ucDefine("Func:: BaseConvert(Number As String, Base As Long)", ucAddr(%uc_Func_BaseConvert))

   ucDefine "Func:: iif(cond As Long, ByExpr TruePart As String, ByExpr FalsePart As String) As String", ucAddr(%uc_Func_IIF_Str)
   ucDefine "Func:: iif(cond As Long, ByExpr TruePart, ByExpr FalsePart)", ucAddr(%uc_Func_IIF)
   ucDefine "Func: Inf() = 1/0"
   ucDefine "Func: NaN() = 0/0"

   ucDefine "Func:: ucAddr(index)", ucAddr(%uc_Func_ucAddr)
   ucDefine "Func:: ValueAtAddr(DataType As Dword, Address As Dword, Index As Long = 0) ~~ ValueAtAddr", ucAddr(%uc_Func_ValueAtAddr)

   ucDefine "Var: NullStr As String At #", ucAddr(%uc_NullString)
   ucDefine "Func:: uCalc(Command As Long, TextArg As String = NullStr, MiscArg1 As Long = 0," _
           +"MiscArg2 As Long = 0, ReturnPtr As Long = 0, t As Long = 0) As Long", ucAddr(%uc_Func_uCalc)

   ucDefine "Func:: uCalcStr(Command As Long, TextArg As String = NullStr, MiscArg1 As Long = 0," _
           +"MiscArg2 As Long = 0, ReturnPtr As Long = 0, t As Long = 0) As String", ucAddr(%uc_Func_uCalcStr)

   ucDefine "Func: Precedence(Item As String) = uCalc("+Str$(%uc_GetItemData)+", Item, 0, "+Str$(%uc_Precedence)+")"

   ucDefine "Func:: uc_Loop(ByExpr DoCondition, ByExpr Expression As AnyType, ByExpr LoopCondition)", ucAddr(%uc_Func_Loop)
   ucDefine "Func:: uc_For(ByHandle Counter As AnyType, Step, Start, Finish, ByExpr Expr As AnyType) As Void", ucAddr(%uc_Func_For)

   ucDefine "Func:: Asc(Character As String, Position As Long = 1) As Long", ucAddr(%uc_Func_Asc)
   ucDefine "Func:: Chr(Code As Long) As String", ucAddr(%uc_Func_Chr)

   ucDefine "Var: _Number As String = '([0-9]+\.)?[0-9]*(e[-+]?[0-9]+)?'"
   ucDefine "Var: _HexNumber As String = '([0-9a-z]+\.)?[0-9a-z]*(e[-+]?[0-9]+)?'"
   ucDefine "Var: _Alpha As String = '[a-z_][0-9a-z_]*'"
   ucDefine "Syntax: {Num:_Number}{Alpha:_Alpha} ::= {Num}*{Alpha}"
   ucDefine "Syntax: {'#b'}{Number:_Number} ::= ~Eval(BaseConvert('{Number}', 2))"
   ucDefine "Syntax: {'#o'}{Number:_Number} ::= ~Eval(BaseConvert('{Number}', 8))"
   ucDefine "Syntax: {'#h'}{Number:_HexNumber} ::= ~Eval(BaseConvert('{Number}', 16))"

   ucDefine "Const: uc_DefineSyntax = " + Str$(%uc_DefineSyntax)
   ucDefine "Func:: SetSyntaxParams(Params As String, Expr As String, t As Dword = 0) As String", ucAddr(%uc_Func_SetSyntaxParams)
   ucDefineSyntax "Macro: {name} [{args:'\([^\)]*\)'}] = {replacement} ::= Syntax: ~Eval(SetSyntaxParams('{args}', '{name}{args} ::= {replacement}'))"
End Sub
#EndIf

#EndIf
